/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.cleanup;

import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.msgsimple.provider.LoadingMessageSourceProvider;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonModuleResourceReleaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonModuleResourceReleaser.class);
    SchedulerService schedulerService;

    public JsonModuleResourceReleaser(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseExecutors() {
        MessageBundle messageBundle;
        LOGGER.debug("Stopping the known executors services");
        Field bundleField = null;
        boolean isAccessible = false;
        try {
            bundleField = JsonNodeReader.class.getDeclaredField("BUNDLE");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.cleanMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | InterruptedException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service reference of the JsonNodeReader class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
        bundleField = null;
        isAccessible = false;
        try {
            bundleField = MessageBundles.class.getDeclaredField("BUNDLES");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            Map bundles = (Map)bundleField.get(null);
            for (MessageBundle bundle : bundles.values()) {
                this.cleanMessageBundle(bundle);
            }
        }
        catch (IllegalAccessException | InterruptedException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the MessageBundles class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
        bundleField = null;
        isAccessible = false;
        try {
            bundleField = ProcessingMessage.class.getDeclaredField("BUNDLE");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.cleanMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | InterruptedException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the ProcessingMessage class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessageBundle(MessageBundle bundle) throws NoSuchFieldException, IllegalAccessException, InterruptedException {
        Field providersField = null;
        Field serviceField = null;
        boolean isProviderFieldAccessible = false;
        boolean isServiceFieldAccessible = false;
        try {
            providersField = MessageBundle.class.getDeclaredField("providers");
            isProviderFieldAccessible = providersField.isAccessible();
            providersField.setAccessible(true);
            List messageSourceProviders = (List)providersField.get(bundle);
            for (MessageSourceProvider provider : messageSourceProviders) {
                if (!(provider instanceof LoadingMessageSourceProvider)) continue;
                try {
                    serviceField = LoadingMessageSourceProvider.class.getDeclaredField("service");
                    isServiceFieldAccessible = serviceField.isAccessible();
                    serviceField.setAccessible(true);
                    ExecutorService service = (ExecutorService)serviceField.get(provider);
                    service.shutdown();
                    service.awaitTermination(10L, TimeUnit.SECONDS);
                }
                finally {
                    if (serviceField != null) {
                        serviceField.setAccessible(isServiceFieldAccessible);
                    }
                    serviceField = null;
                    isServiceFieldAccessible = false;
                }
            }
        }
        finally {
            if (providersField != null) {
                providersField.setAccessible(isProviderFieldAccessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restoreExecutorServices() {
        MessageBundle messageBundle;
        Field bundleField = null;
        boolean isAccessible = false;
        try {
            bundleField = JsonNodeReader.class.getDeclaredField("BUNDLE");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.restoreMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service reference of the JsonNodeReader class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
        bundleField = null;
        isAccessible = false;
        try {
            bundleField = MessageBundles.class.getDeclaredField("BUNDLES");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            Map bundles = (Map)bundleField.get(null);
            for (MessageBundle bundle : bundles.values()) {
                this.restoreMessageBundle(bundle);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the MessageBundles class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
        bundleField = null;
        isAccessible = false;
        try {
            bundleField = ProcessingMessage.class.getDeclaredField("BUNDLE");
            isAccessible = bundleField.isAccessible();
            bundleField.setAccessible(true);
            messageBundle = (MessageBundle)bundleField.get(null);
            this.restoreMessageBundle(messageBundle);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            LOGGER.error("Caught exception while stopping the Executor Service references of the ProcessingMessage class: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            if (bundleField != null) {
                bundleField.setAccessible(isAccessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreMessageBundle(MessageBundle bundle) throws NoSuchFieldException, IllegalAccessException {
        Field providersField = null;
        boolean isProvidersFieldAccessible = false;
        Field serviceField = null;
        boolean isServiceFieldAccessible = false;
        try {
            providersField = MessageBundle.class.getDeclaredField("providers");
            isProvidersFieldAccessible = providersField.isAccessible();
            providersField.setAccessible(true);
            List messageSourceProviders = (List)providersField.get(bundle);
            for (MessageSourceProvider provider : messageSourceProviders) {
                if (!(provider instanceof LoadingMessageSourceProvider)) continue;
                try {
                    serviceField = LoadingMessageSourceProvider.class.getDeclaredField("service");
                    isServiceFieldAccessible = serviceField.isAccessible();
                    serviceField.setAccessible(true);
                    ExecutorService service = (ExecutorService)serviceField.get(provider);
                    if (!service.isShutdown()) continue;
                    service = this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(3).withPrefix("pool"));
                    serviceField.set(provider, service);
                }
                finally {
                    if (serviceField != null) {
                        serviceField.setAccessible(isServiceFieldAccessible);
                        serviceField = null;
                    }
                    isServiceFieldAccessible = false;
                }
            }
        }
        finally {
            if (providersField != null) {
                providersField.setAccessible(isProvidersFieldAccessible);
            }
        }
    }
}

