/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfigurationBuilder;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.module.json.api.JsonError;
import org.mule.module.json.api.JsonSchemaDereferencingMode;
import org.mule.module.json.internal.error.SchemaValidationException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JsonSchemaValidator {
    private final JsonSchema schema;
    private final ObjectMapper objectMapper;

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    private JsonSchemaValidator(JsonSchema schema, ObjectMapper objectMapper) {
        this.schema = schema;
        this.objectMapper = objectMapper;
    }

    public void validate(InputStream input) {
        ProcessingReport report;
        JsonNode jsonNode = this.asJsonNode(input);
        try {
            report = this.schema.validate(jsonNode, true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception was found while trying to validate against json schema. Content was: " + jsonNode.toString())), (Throwable)e);
        }
        if (!report.isSuccess()) {
            throw new SchemaValidationException("Json content is not compliant with schema", this.reportAsJson(report));
        }
    }

    private String reportAsJson(ProcessingReport report) {
        String jsonReport = "[" + Lists.newArrayList((Iterable)report).stream().map(p -> p.asJson().toString()).collect(Collectors.joining(",")) + "]";
        try {
            jsonReport = this.objectMapper.writer(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)this.objectMapper.readTree(jsonReport));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonReport;
    }

    private JsonNode asJsonNode(InputStream input) {
        try {
            return this.objectMapper.readTree(input);
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Input content was not a valid Json document"), (ErrorTypeDefinition)JsonError.INVALID_INPUT_JSON, (Throwable)e);
        }
    }

    public static final class Builder {
        private static final String RESOURCE_PREFIX = "resource:/";
        private String schemaLocation;
        private JsonSchemaDereferencingMode dereferencing = JsonSchemaDereferencingMode.CANONICAL;
        private final Map<String, String> schemaRedirects = new HashMap<String, String>();
        private final ObjectMapper objectMapper = new ObjectMapper();

        private Builder() {
        }

        public Builder setSchemaLocation(String schemaLocation) {
            Preconditions.checkArgument((!JsonSchemaValidator.isBlank(schemaLocation) ? 1 : 0) != 0, (Object)"schemaLocation cannot be null or blank");
            this.schemaLocation = this.formatUri(schemaLocation);
            return this;
        }

        public Builder setDereferencing(JsonSchemaDereferencingMode dereferencing) {
            Preconditions.checkArgument((dereferencing != null ? 1 : 0) != 0, (Object)"dereferencing cannot be null");
            this.dereferencing = dereferencing;
            return this;
        }

        public Builder allowDuplicateKeys(boolean allowDuplicateKeys) {
            if (!allowDuplicateKeys) {
                this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
            }
            return this;
        }

        public Builder allowArbitraryPrecision(boolean allowArbitraryPrecision) {
            if (allowArbitraryPrecision) {
                this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
            }
            return this;
        }

        public Builder addSchemaRedirect(String from, String to) {
            Preconditions.checkArgument((!JsonSchemaValidator.isBlank(from) ? 1 : 0) != 0, (Object)"from cannot be null or blank");
            Preconditions.checkArgument((!JsonSchemaValidator.isBlank(to) ? 1 : 0) != 0, (Object)"to cannot be null or blank");
            this.schemaRedirects.put(this.formatUri(from), this.formatUri(to));
            return this;
        }

        public Builder addSchemaRedirects(Map<String, String> redirects) {
            for (Map.Entry<String, String> redirect : redirects.entrySet()) {
                this.addSchemaRedirect(redirect.getKey(), redirect.getValue());
            }
            return this;
        }

        public JsonSchemaValidator build() {
            URITranslatorConfigurationBuilder translatorConfigurationBuilder = URITranslatorConfiguration.newBuilder();
            for (Map.Entry<String, String> redirect : this.schemaRedirects.entrySet()) {
                String key = this.resolveLocationIfNecessary(redirect.getKey());
                String value = this.resolveLocationIfNecessary(redirect.getValue());
                translatorConfigurationBuilder.addSchemaRedirect(key, value);
            }
            LoadingConfigurationBuilder loadingConfigurationBuilder = LoadingConfiguration.newBuilder().dereferencing(this.dereferencing == JsonSchemaDereferencingMode.CANONICAL ? Dereferencing.CANONICAL : Dereferencing.INLINE).setURITranslatorConfiguration(translatorConfigurationBuilder.freeze());
            LoadingConfiguration loadingConfiguration = loadingConfigurationBuilder.freeze();
            JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfiguration).freeze();
            try {
                return new JsonSchemaValidator(this.loadSchema(factory), this.objectMapper);
            }
            catch (ModuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not initialise JsonSchemaValidator"), (Throwable)e);
            }
        }

        private JsonSchema loadSchema(JsonSchemaFactory factory) {
            try {
                Preconditions.checkState((this.schemaLocation != null ? 1 : 0) != 0, (Object)"schemaLocation has not been provided");
                String realLocation = this.resolveLocationIfNecessary(this.schemaLocation);
                return factory.getJsonSchema(realLocation);
            }
            catch (Exception e) {
                throw new ModuleException(String.format("Could not load JSON schema [%s]. %s", this.schemaLocation, e.getMessage()), (ErrorTypeDefinition)JsonError.SCHEMA_NOT_FOUND, (Throwable)e);
            }
        }

        private String resolveLocationIfNecessary(String path) {
            URI uri = URI.create(path);
            String scheme = uri.getScheme();
            if (scheme == null || "resource".equals(scheme)) {
                return this.openSchema(uri.getPath()).toString();
            }
            return path;
        }

        private URL openSchema(String path) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url == null && path.startsWith("/") && (url = this.openSchema(path.substring(1))) != null) {
                return url;
            }
            if (url == null) {
                throw new IllegalArgumentException("Cannot find schema [" + path + "]");
            }
            return url;
        }

        private String formatUri(String location) {
            URI uri = URI.create(location);
            if (uri.getScheme() == null) {
                if (location.charAt(0) == '/') {
                    location = location.substring(1);
                }
                location = RESOURCE_PREFIX + location;
            }
            return location;
        }
    }
}

