/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.mule.extension.compression.internal.CompressionExtension;
import org.mule.extension.compression.internal.error.exception.CompressionException;
import org.mule.extension.compression.internal.zip.TempZipFile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class CompressionManager
implements Startable,
Stoppable {
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Random RANDOM = new Random();
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private TransformationService transformationService;
    private Scheduler compressionScheduler;

    public void start() throws MuleException {
        this.compressionScheduler = this.schedulerService.cpuIntensiveScheduler();
    }

    public void stop() throws MuleException {
        this.compressionScheduler.stop();
        this.compressionScheduler = null;
    }

    public Result<InputStream, Void> asyncArchive(Map<String, TypedValue<InputStream>> entries, Boolean forceZip64) {
        try {
            PipedInputStreamWithReadExceptionCheck inPipeWithException = new PipedInputStreamWithReadExceptionCheck();
            PipedOutputStream out = new PipedOutputStream(inPipeWithException);
            this.compressionScheduler.submit(() -> {
                try {
                    this.archive(entries, out, forceZip64);
                }
                catch (CompressionException e) {
                    inPipeWithException.fail(e);
                }
            });
            return Result.builder().output((Object)inPipeWithException).mediaType(CompressionExtension.ZIP_MEDIA_TYPE).build();
        }
        catch (CompressionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompressionException(t);
        }
    }

    public TempZipFile toTempZip(InputStream inputStream) throws IOException {
        return new TempZipFile(this.toTempFile(inputStream));
    }

    private File toTempFile(InputStream inputStream) throws IOException {
        String fileName = "mule-compression-buffer" + RANDOM.nextLong() + ".tmp";
        File file = new File(TEMP_DIR, fileName);
        FileUtils.copyStreamToFile((InputStream)inputStream, (File)file);
        return file;
    }

    private void archive(Map<String, TypedValue<InputStream>> entries, OutputStream out, Boolean forceZip64) throws CompressionException {
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(out);){
            entries.forEach((name, content) -> this.addEntry(zip, (String)name, (TypedValue<InputStream>)content, this.transformationService, forceZip64));
        }
        catch (Exception e) {
            throw new CompressionException(e.getCause());
        }
    }

    private void addEntry(ZipArchiveOutputStream zip, String name, TypedValue<InputStream> entryContent, TransformationService transformationService, boolean forceZip64) {
        try {
            int length;
            ZipArchiveEntry newEntry = new ZipArchiveEntry(name);
            if (forceZip64) {
                zip.setUseZip64(Zip64Mode.Always);
            }
            zip.putArchiveEntry((ArchiveEntry)newEntry);
            byte[] buffer = new byte[1024];
            InputStream content = this.getContent(name, entryContent, transformationService);
            while ((length = content.read(buffer)) >= 0) {
                zip.write(buffer, 0, length);
            }
            zip.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new CompressionException(e);
        }
    }

    private InputStream getContent(String name, TypedValue<?> entryContent, TransformationService transformationService) {
        try {
            Object value = entryContent.getValue();
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            return (InputStream)transformationService.transform(value, entryContent.getDataType(), DataType.INPUT_STREAM);
        }
        catch (Exception e) {
            throw new CompressionException("cannot archive entry [" + name + "], content cannot be transformed to InputStream");
        }
    }

    private static final class PipedInputStreamWithReadExceptionCheck
    extends PipedInputStream {
        private final AtomicReference<CompressionException> exception = new AtomicReference<Object>(null);

        private PipedInputStreamWithReadExceptionCheck() {
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.exception.get() != null) {
                throw new RuntimeException((Throwable)((Object)this.exception.get()));
            }
            return super.read(b);
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.exception.get() != null) {
                throw new RuntimeException((Throwable)((Object)this.exception.get()));
            }
            return super.read();
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.exception.get() != null) {
                throw new RuntimeException((Throwable)((Object)this.exception.get()));
            }
            return super.read(b, off, len);
        }

        public void fail(CompressionException e) {
            this.exception.set(e);
        }
    }
}

