/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.internal;

import java.io.InputStream;
import org.mule.extension.compression.api.strategy.CompressorStrategy;
import org.mule.extension.compression.api.strategy.DecompressorStrategy;
import org.mule.extension.compression.internal.error.exception.CompressionException;
import org.mule.extension.compression.internal.error.exception.NullArchiveException;
import org.mule.extension.compression.internal.error.providers.CompressErrorProvider;
import org.mule.extension.compression.internal.error.providers.DecompressErrorProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class CompressionOperations {
    @MediaType(value="*/*", strict=false)
    @Summary(value="Compresses a given content using an specific format")
    @Throws(value={CompressErrorProvider.class})
    public Result<InputStream, Void> compress(@Content TypedValue<InputStream> content, @ParameterDsl(allowReferences=false) @Expression(value=ExpressionSupport.NOT_SUPPORTED) CompressorStrategy compressor) {
        if (content.getValue() == null) {
            throw new CompressionException("cannot compress null content");
        }
        return compressor.compress(content);
    }

    @MediaType(value="*/*", strict=false)
    @Throws(value={DecompressErrorProvider.class})
    @Summary(value="Decompresses a single entry compressed content")
    public InputStream decompress(@Content TypedValue<InputStream> compressed, @ParameterDsl(allowReferences=false) @Expression(value=ExpressionSupport.NOT_SUPPORTED) DecompressorStrategy decompressor) {
        if (compressed.getValue() == null) {
            throw new NullArchiveException();
        }
        return decompressor.decompress(compressed);
    }
}

