/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.api.strategy.zip;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipException;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.mule.extension.compression.api.strategy.DecompressorStrategy;
import org.mule.extension.compression.internal.CompressionManager;
import org.mule.extension.compression.internal.PostActionInputStreamWrapper;
import org.mule.extension.compression.internal.error.exception.DecompressionException;
import org.mule.extension.compression.internal.error.exception.InvalidArchiveException;
import org.mule.extension.compression.internal.error.exception.TooManyEntriesException;
import org.mule.extension.compression.internal.zip.TempZipFile;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.exception.ModuleException;

@DisplayName(value="Zip")
@Alias(value="zip-decompressor")
public class ZipDecompressorStrategy
implements DecompressorStrategy {
    @Inject
    private CompressionManager compressionManager;

    @Override
    public InputStream decompress(TypedValue<InputStream> compressed) throws DecompressionException {
        TempZipFile zip = null;
        try {
            zip = this.compressionManager.toTempZip((InputStream)compressed.getValue());
            Enumeration entries = zip.getEntries();
            if (!entries.hasMoreElements()) {
                throw new InvalidArchiveException("The provided archive has no entries");
            }
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            if (entries.hasMoreElements()) {
                ArrayList<String> allEntries = new ArrayList<String>();
                allEntries.add(entry.getName());
                do {
                    allEntries.add(((ZipArchiveEntry)entries.nextElement()).getName());
                } while (entries.hasMoreElements());
                throw new TooManyEntriesException(allEntries);
            }
            return new PostActionInputStreamWrapper(zip.getInputStream(entry), zip::closeSafely);
        }
        catch (ModuleException e) {
            ZipFile.closeQuietly(zip);
            throw e;
        }
        catch (ZipException e) {
            ZipFile.closeQuietly(zip);
            throw new InvalidArchiveException(e);
        }
        catch (Exception e) {
            ZipFile.closeQuietly(zip);
            throw new DecompressionException(e);
        }
    }
}

