/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.api.strategy.zip;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.mule.extension.compression.api.strategy.ExtractorStrategy;
import org.mule.extension.compression.internal.CompressionManager;
import org.mule.extension.compression.internal.PostActionInputStreamWrapper;
import org.mule.extension.compression.internal.error.exception.DecompressionException;
import org.mule.extension.compression.internal.error.exception.InvalidArchiveException;
import org.mule.extension.compression.internal.zip.TempZipFile;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.exception.ModuleException;

@DisplayName(value="Zip")
@Alias(value="zip-extractor")
public class ZipExtractorStrategy
implements ExtractorStrategy {
    @Inject
    private CompressionManager compressionManager;

    @Override
    public Map<String, InputStream> extract(TypedValue<InputStream> archive) {
        TempZipFile zip = null;
        try {
            zip = this.compressionManager.toTempZip((InputStream)archive.getValue());
            Enumeration entries = zip.getEntries();
            if (!entries.hasMoreElements()) {
                throw new InvalidArchiveException("The provided archive has no entries");
            }
            HashMap<String, InputStream> files = new HashMap<String, InputStream>();
            FinalCountDown countDown = new FinalCountDown(zip::closeSafely);
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                PostActionInputStreamWrapper stream = new PostActionInputStreamWrapper(zip.getInputStream(entry), countDown::countDown);
                files.put(entry.getName(), stream);
                countDown.countUp();
            }
            return files;
        }
        catch (ModuleException e) {
            ZipFile.closeQuietly(zip);
            throw e;
        }
        catch (ZipException e) {
            ZipFile.closeQuietly(zip);
            throw new InvalidArchiveException(e);
        }
        catch (Exception e) {
            ZipFile.closeQuietly(zip);
            throw new DecompressionException(e);
        }
    }

    private class FinalCountDown {
        private int count = 0;
        private final Runnable action;

        public FinalCountDown(Runnable action) {
            this.action = action;
        }

        public void countUp() {
            ++this.count;
        }

        public void countDown() {
            if (--this.count == 0) {
                this.action.run();
            }
        }
    }
}

