/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;

public class AttributesHelper {
    private static final String ANY_RESPONSE_MEDIA_TYPE = "*/*";

    private AttributesHelper() {
    }

    public static MultiMap<String, String> copyImmutableMap(MultiMap<String, String> immutableMap) {
        MultiMap mapParam = new MultiMap();
        immutableMap.keySet().forEach(mapKey -> mapParam.put(mapKey, (Collection)immutableMap.getAll(mapKey)));
        return mapParam;
    }

    public static String addQueryString(String oldQueryString, String key, String value) {
        String newParam = oldQueryString.length() != 0 ? "&" : "";
        try {
            newParam = newParam + URLEncoder.encode(key, "UTF-8");
            if (value != null) {
                newParam = newParam + "=" + URLEncoder.encode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return oldQueryString + newParam;
    }

    public static HttpRequestAttributes replaceParams(HttpRequestAttributes attributes, MultiMap<String, String> headers, MultiMap<String, String> queryParams, String queryString, Map<String, String> uriParams) {
        return new HttpRequestAttributesBuilder(attributes).headers(headers).queryParams(queryParams).queryString(queryString).uriParams(uriParams).build();
    }

    public static List<String> getParamValues(MultiMap<String, String> parameters, String parameterName) {
        return parameters.keySet().stream().filter(header -> header.equalsIgnoreCase(parameterName)).map(arg_0 -> parameters.getAll(arg_0)).findFirst().orElse(Collections.emptyList());
    }

    public static String getContentType(MultiMap<String, String> headers) throws UnsupportedMediaTypeException {
        List<String> contentTypes = AttributesHelper.getParamValues(headers, HeaderName.CONTENT_TYPE.getName());
        if (CollectionUtils.isEmpty(contentTypes)) {
            return null;
        }
        String contentType = contentTypes.get(0);
        if (contentTypes.size() > 1 || contentType.contains(ArrayHeaderDelimiter.COMMA.getDelimiterValue())) {
            throw new UnsupportedMediaTypeException("Unsupported mediaType. Multiple values are not allowed for Content-Type header param");
        }
        return Strings.isNullOrEmpty((String)contentType) ? null : AttributesHelper.getMediaType(contentType);
    }

    public static String getMediaType(String mediaType) throws UnsupportedMediaTypeException {
        try {
            MediaType mType = MediaType.parse((String)mediaType);
            return String.format("%s/%s", mType.getPrimaryType(), mType.getSubType());
        }
        catch (Exception e) {
            String message = mediaType == null ? "MediaType is null" : e.getMessage();
            throw new UnsupportedMediaTypeException(message);
        }
    }

    public static String getAcceptedResponseMediaTypes(MultiMap<String, String> headers) {
        String acceptableResponseMediaTypes = AttributesHelper.getParamValues(headers, HeaderName.ACCEPT.getName()).stream().collect(Collectors.joining(ArrayHeaderDelimiter.COMMA.getDelimiterValue()));
        return Strings.isNullOrEmpty((String)acceptableResponseMediaTypes) ? ANY_RESPONSE_MEDIA_TYPE : acceptableResponseMediaTypes;
    }
}

