/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;
import org.mule.module.apikit.deserializing.BaseAttributeDeserializer;

public class ArrayHeaderAttributeDeserializer
extends BaseAttributeDeserializer {
    private static final char DOUBLE_QUOTES = '\"';
    private static final char OPENING_CURLY_BRACE = '{';
    private static final char CLOSING_CURLY_BRACE = '}';
    private ArrayHeaderDelimiter arrayHeaderDelimiter;

    public ArrayHeaderAttributeDeserializer(ArrayHeaderDelimiter arrayHeaderDelimiter) {
        this.arrayHeaderDelimiter = arrayHeaderDelimiter;
    }

    @Override
    public List<String> deserializeValue(String attributeValue) {
        if (StringUtils.isBlank((CharSequence)attributeValue)) {
            return Collections.emptyList();
        }
        char delimiter = this.arrayHeaderDelimiter.getDelimiterValue().charAt(0);
        char[] chars = attributeValue.toCharArray();
        StringBuffer curVal = new StringBuffer();
        boolean inQuotes = false;
        int curlyBracesStackCount = 0;
        boolean startCollectChar = false;
        ArrayList<String> headerValues = new ArrayList<String>();
        for (char ch : chars) {
            if (inQuotes) {
                startCollectChar = true;
                if (ch == '\"') {
                    boolean bl = inQuotes = curlyBracesStackCount > 0;
                    if (!inQuotes) continue;
                    curVal.append(ch);
                    continue;
                }
                if (ch == '{') {
                    ++curlyBracesStackCount;
                    curVal.append(ch);
                    continue;
                }
                if (ch == '}') {
                    --curlyBracesStackCount;
                    curVal.append(ch);
                    continue;
                }
                curVal.append(ch);
                continue;
            }
            if (curlyBracesStackCount > 0) {
                if (ch == '}') {
                    --curlyBracesStackCount;
                } else if (ch == '{') {
                    ++curlyBracesStackCount;
                }
                if (curlyBracesStackCount < 0) continue;
                curVal.append(ch);
                continue;
            }
            if (ch == '\"') {
                boolean bl = inQuotes = curlyBracesStackCount <= 0;
                if (!startCollectChar) continue;
                curVal.append(ch);
                continue;
            }
            if (ch == '{') {
                ++curlyBracesStackCount;
                curVal.append(ch);
                continue;
            }
            if (ch == delimiter) {
                this.addValueToList(headerValues, curVal);
                curVal = new StringBuffer();
                startCollectChar = false;
                continue;
            }
            if (ch == '\r' || ch == '\n') continue;
            curVal.append(ch);
        }
        this.addValueToList(headerValues, curVal);
        return headerValues;
    }

    private void addValueToList(List<String> headerValues, StringBuffer curVal) {
        String value = curVal.toString();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            headerValues.add(value);
        }
    }
}

