/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataTextParameter;

public abstract class MultipartEntityBuilder {
    private static Pattern HEADERS_PATTERN = Pattern.compile("([\\w-]+): (.*)");

    public abstract void addDefault(String var1, String var2);

    public abstract Multipart getOutput();

    protected abstract void addPart(String var1, byte[] var2, String var3, String var4, String var5);

    public abstract void handleBinaryPart(MultipartStream var1, Parameter var2, String var3, String var4, String var5, String var6) throws InvalidFormParameterException;

    public void handleTextPart(MultipartStream multipartStream, Parameter parameter, String name, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        try {
            byte[] buf = this.partToByteArray(multipartStream);
            String body = IOUtils.toString((InputStream)new ByteArrayInputStream(buf));
            if (parameter != null) {
                new MultipartFormDataTextParameter(body).validate(parameter);
            }
            this.addPart(name, buf, contentType, fileName, headers);
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    protected byte[] partToByteArray(MultipartStream stream) throws IOException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        stream.readBodyData((OutputStream)content);
        return content.toByteArray();
    }

    protected Map<String, String> getHeaders(String headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = HEADERS_PATTERN.matcher(headers);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            map.put(name, value);
        }
        return map;
    }
}

