/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.entity.mime.MIME;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilder;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilderWithDefaults;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilderWithoutDefaults;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

public class MultipartBuilder {
    private final String boundary;
    private final String contentType;
    private final CursorStreamProvider cursorProvider;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<String, Parameter> formParameters = new HashMap<String, Parameter>();
    private static Pattern NAME_PATTERN = Pattern.compile("Content-Disposition:\\s*form-data;[^\\n]*\\sname=([^\\n;]*?)[;\\n\\s]");
    private static Pattern FILE_NAME_PATTERN = Pattern.compile("filename=\"([^\"]+)\"");
    private static Pattern CONTENT_TYPE_PATTERN = Pattern.compile("Content-Type:\\s*([^\\n]+)");

    public MultipartBuilder(CursorStreamProvider cursorProvider, String contentType, String boundary) {
        this.cursorProvider = cursorProvider;
        this.boundary = boundary;
        this.contentType = contentType;
    }

    public MultipartBuilder withDefaultValue(String key, String value) {
        this.defaultValues.put(key, value);
        return this;
    }

    public MultipartBuilder withExpectedParameter(String expectedKey, Parameter parameter) {
        this.formParameters.put(expectedKey, parameter);
        return this;
    }

    public Multipart build() throws InvalidFormParameterException {
        try {
            MultipartEntityBuilder multipartEntityBuilder;
            MultipartStream multipartStream = new MultipartStream((InputStream)this.cursorProvider.openCursor(), this.boundary.getBytes(MIME.UTF8_CHARSET), StreamUtils.BUFFER_SIZE.intValue());
            boolean nextPart = multipartStream.skipPreamble();
            HashSet<String> parametersInPayload = new HashSet<String>();
            MultipartEntityBuilder multipartEntityBuilder2 = multipartEntityBuilder = this.defaultValues.size() == 0 ? new MultipartEntityBuilderWithoutDefaults(this.contentType, (CursorProvider)this.cursorProvider) : new MultipartEntityBuilderWithDefaults(this.boundary);
            while (nextPart) {
                String headers = multipartStream.readHeaders();
                String name = this.getName(headers);
                String fileName = this.getFileName(headers);
                String contentType = this.getContentType(headers);
                parametersInPayload.add(name);
                Parameter parameter = this.formParameters.get(name);
                if (parameter != null && parameter.getFileProperties().isPresent()) {
                    multipartEntityBuilder.handleBinaryPart(multipartStream, parameter, name, contentType, fileName, headers);
                } else {
                    multipartEntityBuilder.handleTextPart(multipartStream, parameter, name, contentType, fileName, headers);
                }
                nextPart = multipartStream.readBoundary();
            }
            for (Map.Entry<String, String> defaultValue : this.defaultValues.entrySet()) {
                if (parametersInPayload.contains(defaultValue.getKey())) continue;
                multipartEntityBuilder.addDefault(defaultValue.getKey(), defaultValue.getValue());
            }
            return multipartEntityBuilder.getOutput();
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    private String getFileName(String headers) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(headers);
        return !matcher.find() ? null : matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getName(String headers) throws InvalidFormParameterException {
        Matcher matcher = NAME_PATTERN.matcher(headers);
        if (!matcher.find()) {
            throw new InvalidFormParameterException("Unable to get name from form-data");
        }
        return matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getContentType(String headers) {
        Matcher matcher = CONTENT_TYPE_PATTERN.matcher(headers);
        return !matcher.find() ? MediaType.TEXT.toString() : matcher.group(1);
    }
}

