/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.IOException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartEntityBuilder;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataBinaryParameter;
import org.mule.module.apikit.validation.body.form.transformation.MultipartWithDefaults;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartEntityBuilderWithDefaults
extends MultipartEntityBuilder {
    private final org.apache.http.entity.mime.MultipartEntityBuilder entityBuilder;

    public MultipartEntityBuilderWithDefaults(String boundary) {
        this.entityBuilder = org.apache.http.entity.mime.MultipartEntityBuilder.create().setBoundary(boundary);
    }

    @Override
    public void handleBinaryPart(MultipartStream multipartStream, Parameter parameter, String name, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        try {
            byte[] buf = this.partToByteArray(multipartStream);
            if (parameter != null) {
                new MultipartFormDataBinaryParameter(buf.length, MediaType.parse((String)contentType)).validate(parameter);
            }
            this.addPart(name, buf, contentType, fileName, headers);
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    @Override
    public void addDefault(String key, String value) {
        this.entityBuilder.addTextBody(key, value);
    }

    @Override
    public Multipart getOutput() {
        return new MultipartWithDefaults(this.entityBuilder.build());
    }

    @Override
    protected void addPart(String name, byte[] buf, String contentType, String fileName, String headers) {
        FormBodyPartBuilder formBodyPartBuilder = FormBodyPartBuilder.create((String)name, (ContentBody)new ByteArrayBody(buf, ContentType.parse((String)contentType), fileName));
        this.getHeaders(headers).forEach((arg_0, arg_1) -> ((FormBodyPartBuilder)formBodyPartBuilder).addField(arg_0, arg_1));
        this.entityBuilder.addPart(formBodyPartBuilder.build());
    }
}

