/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.deserializing.AttributesDeserializingStrategies;
import org.mule.module.apikit.api.exception.InvalidHeaderException;
import org.mule.module.apikit.deserializing.AttributeDeserializer;
import org.mule.module.apikit.deserializing.AttributesDeserializerFactory;
import org.mule.module.apikit.deserializing.AttributesDeserializingStrategyIdentifier;
import org.mule.module.apikit.deserializing.MimeTypeParser;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.runtime.api.util.MultiMap;

public class HeadersValidator {
    private static final String PLACEHOLDER_TOKEN = "{?}";
    private final Action action;
    private final List<String> mimeTypes;

    public HeadersValidator(Action action) {
        this.action = action;
        this.mimeTypes = this.getResponseMimeTypes(action);
    }

    public MultiMap<String, String> validateAndAddDefaults(MultiMap<String, String> incomingHeaders, boolean headersStrictValidation, AttributesDeserializingStrategies attributesDeserializingStrategy) throws InvalidHeaderException, NotAcceptableException {
        MultiMap<String, String> headersWithDefaults = this.analyseRequestHeaders(incomingHeaders, headersStrictValidation, attributesDeserializingStrategy);
        this.analyseAcceptHeader(headersWithDefaults);
        return headersWithDefaults;
    }

    private MultiMap<String, String> analyseRequestHeaders(MultiMap<String, String> incomingHeaders, boolean headersStrictValidation, AttributesDeserializingStrategies attributesDeserializingStrategy) throws InvalidHeaderException {
        if (headersStrictValidation) {
            this.validateHeadersStrictly((Map<String, String>)incomingHeaders);
        }
        MultiMap<String, String> copyIncomingHeaders = MultiMap.emptyMultiMap();
        for (Map.Entry entry : this.action.getHeaders().entrySet()) {
            String ramlHeader = (String)entry.getKey();
            Parameter ramlType = (Parameter)entry.getValue();
            if (ramlHeader.contains(PLACEHOLDER_TOKEN)) {
                this.validateHeadersWithPlaceholderToken(incomingHeaders, ramlHeader, ramlType);
                continue;
            }
            List<String> values = AttributesHelper.getParamValues(incomingHeaders, ramlHeader);
            if (values.isEmpty() && ramlType.isRequired()) {
                throw new InvalidHeaderException("Required header '" + ramlHeader + "' not specified");
            }
            if (values.isEmpty() && ramlType.getDefaultValue() != null) {
                copyIncomingHeaders = this.getMutableCopy(incomingHeaders, copyIncomingHeaders);
                copyIncomingHeaders.put((Object)ramlHeader, (Object)ramlType.getDefaultValue());
            }
            if (!values.isEmpty() && ramlType.isArray()) {
                values = this.deserializeValues(values, attributesDeserializingStrategy);
                copyIncomingHeaders = this.getMutableCopy(incomingHeaders, copyIncomingHeaders);
                copyIncomingHeaders.remove((Object)ramlHeader);
                copyIncomingHeaders.put((Object)ramlHeader, values);
            }
            this.validateHeader(values, ramlHeader, ramlType);
        }
        return copyIncomingHeaders.isEmpty() ? incomingHeaders : copyIncomingHeaders;
    }

    private MultiMap<String, String> getMutableCopy(MultiMap<String, String> incomingHeaders, MultiMap<String, String> copyIncomingHeaders) {
        if (copyIncomingHeaders.isEmpty()) {
            return AttributesHelper.copyImmutableMap(incomingHeaders);
        }
        return copyIncomingHeaders;
    }

    private void validateHeadersWithPlaceholderToken(MultiMap<String, String> copyIncomingHeaders, String ramlHeader, Parameter ramlType) throws InvalidHeaderException {
        String regex = ramlHeader.replace(PLACEHOLDER_TOKEN, ".*");
        for (String incomingHeader : copyIncomingHeaders.keySet()) {
            if (!incomingHeader.matches(regex)) continue;
            this.validateHeader(copyIncomingHeaders.getAll((Object)incomingHeader), ramlHeader, ramlType);
        }
    }

    private void validateHeadersStrictly(Map<String, String> headers) throws InvalidHeaderException {
        Set standardHeaders;
        Set ramlHeaders = this.action.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Set templateHeaders = ramlHeaders.stream().filter(header -> header.contains(PLACEHOLDER_TOKEN)).map(header -> header.replace(PLACEHOLDER_TOKEN, ".*")).collect(Collectors.toSet());
        Set unmatchedHeaders = headers.keySet().stream().filter(header -> templateHeaders.stream().noneMatch(header::matches)).collect(Collectors.toSet());
        Sets.SetView undefinedHeaders = Sets.difference(unmatchedHeaders, (Set)Sets.union(ramlHeaders, standardHeaders = Arrays.stream(HeaderName.values()).map(header -> header.getName().toLowerCase()).collect(Collectors.toSet())));
        if (!undefinedHeaders.isEmpty()) {
            throw new InvalidHeaderException(String.format("[%s] %s", Joiner.on((String)", ").join((Iterable)undefinedHeaders), "headers are not defined in RAML and strict headers validation property is true."));
        }
    }

    private void validateHeader(List<String> values, String name, Parameter type) throws InvalidHeaderException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() > 1 && !type.isArray() && !type.isRepeat()) {
            throw new InvalidHeaderException("Header " + name + " is not repeatable");
        }
        if (type.isArray()) {
            this.validateTypeArrayValues(name, values, type);
        } else {
            this.validateTypeValue(name, values.get(0), type);
        }
    }

    private List<String> deserializeValues(List<String> listOfDelimitedValues, AttributesDeserializingStrategies deserializingStrategies) {
        AttributeDeserializer deserializer = AttributesDeserializerFactory.INSTANCE.getDeserializer(AttributesDeserializingStrategyIdentifier.ARRAY_HEADER_DESERIALIZING_STRATEGY, deserializingStrategies);
        return deserializer.deserializeListOfValues(listOfDelimitedValues);
    }

    private void validateTypeArrayValues(String name, List<String> values, Parameter type) throws InvalidHeaderException {
        String yamlArrayValue = values.stream().collect(Collectors.joining("\n- ", "- ", ""));
        this.validateTypeValue(name, yamlArrayValue, type);
    }

    private void validateTypeValue(String name, String value, Parameter type) throws InvalidHeaderException {
        if (!type.validate(value)) {
            throw new InvalidHeaderException(String.format("Invalid value '%s' for header '%s'", value, name));
        }
    }

    private void analyseAcceptHeader(MultiMap<String, String> incomingHeaders) throws NotAcceptableException {
        if (this.action == null || this.action.getResponses() == null || this.mimeTypes.isEmpty()) {
            return;
        }
        MediaType bestMatch = MimeTypeParser.bestMatchForAcceptHeader(this.mimeTypes, AttributesHelper.getAcceptedResponseMediaTypes(incomingHeaders));
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
    }

    private List<String> getResponseMimeTypes(Action action) {
        String status = this.getSuccessStatus(action);
        Response response = (Response)action.getResponses().get(status);
        if (response != null && response.hasBody()) {
            return new ArrayList<String>(response.getBody().keySet());
        }
        return new ArrayList<String>();
    }

    protected String getSuccessStatus(Action action) {
        for (String status : action.getResponses().keySet()) {
            if ("default".equalsIgnoreCase(status)) {
                return "200";
            }
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return status;
        }
        return "200";
    }
}

