/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;

public class CharsetUtils {
    private CharsetUtils() {
    }

    public static String getCharset(MultiMap<String, String> headers, Object payload) {
        String charset = CharsetUtils.getHeaderCharset(headers);
        if (charset == null && payload instanceof TypedValue) {
            return CharsetUtils.normalizeCharset(CharsetUtils.getEncoding((TypedValue)payload));
        }
        return CharsetUtils.normalizeCharset(charset);
    }

    private static String getHeaderCharset(MultiMap<String, String> headers) {
        return CharsetUtils.getCharset(AttributesHelper.getParamIgnoreCase(headers, "Content-Type"));
    }

    public static String getCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        MediaType mediaType = MediaType.parse((String)contentType);
        Optional charset = mediaType.getCharset();
        return charset.map(Charset::name).orElse(null);
    }

    private static String normalizeCharset(String encoding) {
        if (encoding != null && encoding.matches("(?i)UTF-16.+")) {
            return "UTF-16";
        }
        return encoding;
    }

    private static <T> String getEncoding(TypedValue<T> typedValue) {
        return typedValue.getDataType().getMediaType().getCharset().orElse(Charset.defaultCharset()).toString();
    }

    public static byte[] trimBom(byte[] content) {
        int bomSize = 0;
        if (content.length > 4 && (content[0] == 0 && content[1] == 0 && content[2] == -2 && content[3] == -1 || content[0] == -1 && content[1] == -2 && content[2] == 0 && content[3] == 0)) {
            bomSize = 4;
        }
        if (content.length > 3 && bomSize == 0 && content[0] == -17 && content[1] == -69 && content[2] == -65) {
            bomSize = 3;
        }
        if (content.length > 2 && bomSize == 0 && (content[0] == -2 && content[1] == -1 || content[0] == -1 && content[1] == -2)) {
            bomSize = 2;
        }
        if (bomSize > 0) {
            int trimmedSize = content.length - bomSize;
            byte[] trimmedArray = new byte[trimmedSize];
            System.arraycopy(content, bomSize, trimmedArray, 0, trimmedSize);
            return trimmedArray;
        }
        return content;
    }
}

