/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Collections;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.utils.MuleVersionUtils;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ApikitExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    public static final String EXTENSION_NAME = "APIKit";
    public static final String PREFIX_NAME = "apikit";
    public static final String EXTENSION_DESCRIPTION = "APIKit plugin";
    public static final String VENDOR = "Mulesoft";
    public static final String VERSION = "1.3.7-SNAPSHOT";
    public static final String XSD_FILE_NAME = "mule-apikit.xsd";
    private static final String UNESCAPED_LOCATION_PREFIX = "http://";
    private static final String SCHEMA_LOCATION = "www.mulesoft.org/schema/mule/mule-apikit";
    private static final String SCHEMA_VERSION = "current";
    private static final String EXTENSION_NAMESPACE = "APIKIT";
    protected final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        ErrorModel muleAnyErrorType = ErrorModelBuilder.newError((String)"ANY", (String)Errors.CORE_NAMESPACE_NAME).build();
        ErrorModel apikitAnyErrorType = ErrorModelBuilder.newError((String)"ANY", (String)EXTENSION_NAMESPACE).withParent(muleAnyErrorType).build();
        ErrorModel badRequestErrorModel = ErrorModelBuilder.newError((String)"BAD_REQUEST", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        ErrorModel notAcceptableErrorModel = ErrorModelBuilder.newError((String)"NOT_ACCEPTABLE", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        ErrorModel unsupportedMediaTypeErrorModel = ErrorModelBuilder.newError((String)"UNSUPPORTED_MEDIA_TYPE", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        ErrorModel methodNotAllowedErrorModel = ErrorModelBuilder.newError((String)"METHOD_NOT_ALLOWED", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        ErrorModel notFoundErrorModel = ErrorModelBuilder.newError((String)"NOT_FOUND", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        ErrorModel notImplementedErrorModel = ErrorModelBuilder.newError((String)"NOT_IMPLEMENTED", (String)EXTENSION_NAMESPACE).withParent(apikitAnyErrorType).build();
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX_NAME).setXsdFileName(XSD_FILE_NAME).setSchemaVersion(VERSION).setSchemaLocation(String.format("%s/%s/%s", "http://www.mulesoft.org/schema/mule/mule-apikit", SCHEMA_VERSION, XSD_FILE_NAME)).setNamespace("http://www.mulesoft.org/schema/mule/mule-apikit").build();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        extensionDeclarer.named(EXTENSION_NAME).describedAs(EXTENSION_DESCRIPTION).fromVendor(VENDOR).onVersion(VERSION).withCategory(Category.COMMUNITY).withXmlDsl(xmlDslModel).withErrorModel(badRequestErrorModel).withErrorModel(apikitAnyErrorType).withErrorModel(notAcceptableErrorModel).withErrorModel(unsupportedMediaTypeErrorModel).withErrorModel(methodNotAllowedErrorModel).withErrorModel(notFoundErrorModel).withErrorModel(notImplementedErrorModel);
        extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)typeLoader.load(HttpRequestAttributes.class)));
        StereotypeModel apikitConfigStereotype = StereotypeModelBuilder.newStereotype((String)"APIKIT_CONFIG", (String)EXTENSION_NAMESPACE).withParent(MuleStereotypes.CONFIG).build();
        ConfigurationDeclarer apikitConfig = extensionDeclarer.withConfig("config").describedAs(PREFIX_NAME).withStereotype(apikitConfigStereotype);
        ParameterGroupDeclarer parameterGroupDeclarer = apikitConfig.onDefaultParameterGroup();
        parameterGroupDeclarer.withOptionalParameter("raml").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("api").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withRequiredParameter("outboundHeadersMapName").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withRequiredParameter("httpStatusVarName").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("keepApiBaseUri").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("keepRamlBaseUri").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("disableValidations").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("queryParamsStrictValidation").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("headersStrictValidation").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("parser").defaultingTo((Object)ParserMode.AUTO).ofType(typeLoader.load(ParserMode.class));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("flowMappings").withDsl(ParameterDslConfiguration.builder().allowsReferences(false).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType((MetadataType)this.typeBuilder.arrayType().of(typeLoader.load(FlowMapping.class)).build());
        OperationDeclarer routerDeclarer = apikitConfig.withOperation("router");
        routerDeclarer.withOutputAttributes().ofType(typeLoader.load(HttpRequestAttributes.class));
        routerDeclarer.withOutput().ofType(typeLoader.load(Object.class));
        ((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)routerDeclarer.withErrorModel(badRequestErrorModel)).withErrorModel(notAcceptableErrorModel)).withErrorModel(unsupportedMediaTypeErrorModel)).withErrorModel(methodNotAllowedErrorModel)).withErrorModel(notFoundErrorModel);
        this.addConfigRefParameter(routerDeclarer, apikitConfigStereotype);
        OperationDeclarer consoleDeclarer = apikitConfig.withOperation("console");
        consoleDeclarer.withOutputAttributes().ofType(typeLoader.load(HttpRequestAttributes.class));
        consoleDeclarer.withOutput().ofType(typeLoader.load(Object.class));
        consoleDeclarer.withErrorModel(notFoundErrorModel);
        this.addConfigRefParameter(consoleDeclarer, apikitConfigStereotype);
    }

    private void addConfigRefParameter(OperationDeclarer declarer, StereotypeModel apikitConfigStereotype) {
        if (MuleVersionUtils.isAtLeast("4.3.0-SNAPSHOT")) {
            declarer.onDefaultParameterGroup().withRequiredParameter("config-ref").describedAs("The name of the configuration to be used to execute this component").withRole(ParameterRole.BEHAVIOUR).withDsl(ParameterDslConfiguration.builder().allowsReferences(true).build()).ofType(ApikitExtensionLoadingDelegate.buildConfigRefType()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withAllowedStereotypes(Collections.singletonList(apikitConfigStereotype));
        }
    }

    private static MetadataType buildConfigRefType() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(ConfigurationProvider.class.getName()).build();
    }
}

