/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataBinaryParameter;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataParameter;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataTextParameter;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartFormData {
    private static Pattern NAME_PATTERN = Pattern.compile("Content-Disposition:\\s*form-data;[^\\n]*\\sname=([^\\n;]*?)[;\\n\\s]");
    private static Pattern HEADERS_PATTERN = Pattern.compile("([\\w-]+): (.*)");
    private static Pattern FILE_NAME_PATTERN = Pattern.compile("filename=\"([^\"]+)\"");
    private static Pattern CONTENT_TYPE_PATTERN = Pattern.compile("Content-Type:\\s*([^\\n]+)");
    private final InputStream inputStream;
    private final String boundary;
    private MultipartStream multipartStream;
    private MultipartEntityBuilder multipartEntityBuilder;

    public MultipartFormData(InputStream inputStream, String boundary) {
        this.inputStream = inputStream;
        this.boundary = boundary;
        this.multipartEntityBuilder = MultipartEntityBuilder.create().setBoundary(boundary);
    }

    public Map<String, MultipartFormDataParameter> getFormDataParameters() throws InvalidFormParameterException {
        HashMap<String, MultipartFormDataParameter> multiMapParameters = new HashMap<String, MultipartFormDataParameter>();
        try {
            this.multipartStream = new MultipartStream(this.inputStream, this.boundary.getBytes(MIME.UTF8_CHARSET), StreamUtils.BUFFER_SIZE.intValue(), null);
            boolean nextPart = this.multipartStream.skipPreamble();
            while (nextPart) {
                String headers = this.multipartStream.readHeaders();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.multipartStream.readBodyData((OutputStream)baos);
                byte[] buf = baos.toByteArray();
                String name = this.getName(headers);
                String fileName = this.getFileName(headers);
                String contentType = this.getContentType(headers);
                FormBodyPartBuilder formBodyPartBuilder = FormBodyPartBuilder.create((String)name, (ContentBody)new ByteArrayBody(buf, ContentType.parse((String)contentType), fileName));
                this.getHeaders(headers).forEach((headerName, value) -> formBodyPartBuilder.addField(headerName, value));
                this.multipartEntityBuilder.addPart(formBodyPartBuilder.build());
                MediaType mediaType = MediaType.parse((String)contentType);
                if (mediaType.matches(MediaType.TEXT)) {
                    String body = IOUtils.toString((InputStream)new ByteArrayInputStream(buf));
                    multiMapParameters.put(name, new MultipartFormDataTextParameter(body, mediaType));
                } else {
                    multiMapParameters.put(name, new MultipartFormDataBinaryParameter(buf, mediaType));
                }
                nextPart = this.multipartStream.readBoundary();
            }
        }
        catch (Exception e) {
            throw new InvalidFormParameterException(e);
        }
        return multiMapParameters;
    }

    private Map<String, String> getHeaders(String headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = HEADERS_PATTERN.matcher(headers);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            map.put(name, value);
        }
        return map;
    }

    private String getFileName(String headers) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(headers);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getName(String headers) throws InvalidFormParameterException {
        Matcher matcher = NAME_PATTERN.matcher(headers);
        if (!matcher.find()) {
            throw new InvalidFormParameterException("Unable to get name from form-data");
        }
        return matcher.group(1).replace("\"", "").replace("'", "");
    }

    private String getContentType(String headers) {
        Matcher matcher = CONTENT_TYPE_PATTERN.matcher(headers);
        if (!matcher.find()) {
            return MediaType.TEXT.toString();
        }
        return matcher.group(1);
    }

    public void addDefault(String key, String value) {
        this.multipartEntityBuilder.addTextBody(key, value);
    }

    public InputStream build() throws InvalidFormParameterException {
        try {
            return this.getInputStream(this.multipartEntityBuilder.build());
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    private InputStream getInputStream(HttpEntity httpEntity) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        httpEntity.writeTo((OutputStream)outStream);
        outStream.flush();
        return new ByteArrayInputStream(outStream.toByteArray());
    }
}

