/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.CharsetUtils;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PayloadHelper.class);

    public static String getPayloadAsString(Object input, String charset) throws BadRequestException {
        try {
            byte[] bytes = PayloadHelper.getPayloadAsByteArray(input);
            return IOUtils.toString((byte[])CharsetUtils.trimBom(bytes), (String)charset);
        }
        catch (IOException e) {
            throw new BadRequestException("Error processing request: " + e.getMessage());
        }
    }

    public static byte[] getPayloadAsByteArray(Object input) throws IOException {
        if (input instanceof CursorStreamProvider) {
            return IOUtils.toByteArray((InputStream)((InputStream)((CursorStreamProvider)input).openCursor()));
        }
        if (input instanceof RewindableInputStream) {
            RewindableInputStream rewindable = (RewindableInputStream)input;
            byte[] bytes = IOUtils.toByteArray((InputStream)rewindable);
            rewindable.rewind();
            return bytes;
        }
        if (input instanceof InputStream) {
            return IOUtils.toByteArray((InputStream)((InputStream)input));
        }
        if (input instanceof String) {
            return ((String)input).getBytes();
        }
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input != null) {
            throw new IOException("Don't know how to get " + input.getClass().getName());
        }
        throw new IOException("Don't know how to get payload");
    }
}

