/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.mule.apikit.model.Resource;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.CharsetUtils;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.MethodNotAllowedException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.validation.ValidBody;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.module.apikit.validation.AttributesValidator;
import org.mule.module.apikit.validation.BodyValidator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    private static Logger LOGGER = LoggerFactory.getLogger(RequestValidator.class);

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload) throws MuleRestException {
        return RequestValidator.validate(config, resource, attributes, resolvedVariables, payload, null, null);
    }

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload, ErrorTypeRepository errorTypeRepository) throws MuleRestException {
        return RequestValidator.validate(config, resource, attributes, resolvedVariables, payload, null, errorTypeRepository);
    }

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload, String charset) throws MuleRestException {
        return RequestValidator.validate(config, resource, attributes, resolvedVariables, payload, charset, null);
    }

    public static ValidRequest validate(ValidationConfig config, Resource resource, HttpRequestAttributes attributes, ResolvedVariables resolvedVariables, Object payload, String charset, ErrorTypeRepository errorTypeRepository) throws MuleRestException {
        ValidBody validBody;
        HttpRequestAttributes httpRequestAttributes;
        if (config.isDisableValidations()) {
            httpRequestAttributes = attributes;
            validBody = new ValidBody(payload);
        } else {
            String method;
            if (resource == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unexpected error. Resource cannot be null"));
            }
            payload = RequestValidator.makePayloadRepeatable(payload);
            if (charset == null) {
                MultiMap headers = attributes.getHeaders();
                try {
                    charset = RequestValidator.getCharset((MultiMap<String, String>)headers, payload);
                }
                catch (IOException e) {
                    throw new BadRequestException(e.getMessage());
                }
            }
            if (resource.getAction(method = attributes.getMethod().toLowerCase()) == null) {
                String version = (String)resolvedVariables.get("version");
                throw new MethodNotAllowedException(resource.getResolvedUri(version) + " : " + method);
            }
            httpRequestAttributes = AttributesValidator.validateAndAddDefaults(attributes, resource, resolvedVariables, config);
            validBody = BodyValidator.validate(resource.getAction(method), attributes, payload, config, charset, errorTypeRepository);
        }
        httpRequestAttributes = RequestValidator.addUriParams(resolvedVariables, httpRequestAttributes);
        return ValidRequest.builder().withAttributes(httpRequestAttributes).withBody(validBody).build();
    }

    private static HttpRequestAttributes addUriParams(ResolvedVariables resolvedVariables, HttpRequestAttributes httpRequestAttributes) {
        MultiMap<String, String> uriParams = new MultiMap<String, String>(httpRequestAttributes.getUriParams());
        for (String name : resolvedVariables.names()) {
            String value = String.valueOf(resolvedVariables.get(name));
            uriParams = AttributesHelper.addParam(uriParams, name, value);
        }
        return new HttpRequestAttributesBuilder(httpRequestAttributes).uriParams((Map)uriParams).build();
    }

    private static Object makePayloadRepeatable(Object payload) {
        if (payload instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)payload;
            Object payloadValue = typedValue.getValue();
            if (payloadValue instanceof InputStream) {
                RewindableInputStream rewindable = new RewindableInputStream((InputStream)payloadValue);
                return new TypedValue((Object)rewindable, typedValue.getDataType());
            }
        } else if (payload instanceof InputStream && !(payload instanceof RewindableInputStream)) {
            return new RewindableInputStream((InputStream)payload);
        }
        return payload;
    }

    private static String getCharset(MultiMap<String, String> headers, Object payload) throws IOException {
        String charset = RequestValidator.getHeaderCharset(headers);
        if (charset == null) {
            if (payload instanceof TypedValue) {
                TypedValue typedValue = (TypedValue)payload;
                byte[] payloadValue = PayloadHelper.getPayloadAsByteArray(typedValue.getValue());
                charset = CharsetUtils.getEncoding(typedValue, (Object)payloadValue, LOGGER);
            } else {
                charset = CharsetUtils.getEncoding(PayloadHelper.getPayloadAsByteArray(payload), LOGGER);
            }
        }
        return charset;
    }

    private static String getHeaderCharset(MultiMap<String, String> headers) {
        return CharsetUtils.getCharset(AttributesHelper.getParamIgnoreCase(headers, "Content-Type"));
    }
}

