/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.EventHelper;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.raml.parser.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CharsetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CharsetUtils.class);

    public static String getEncoding(CoreEvent event, byte[] bytes, Logger logger) {
        String encoding = CharsetUtils.getHeaderCharset(event.getMessage());
        if (encoding == null) {
            encoding = StreamUtils.detectEncoding((byte[])bytes);
            logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
            if (encoding == null && (encoding = CharsetUtils.getPayloadCharset(event.getMessage(), logger)) == null) {
                encoding = EventHelper.getEncoding(event).toString();
                logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
            }
        } else {
            logger.debug("Request Content-Type charset: " + CharsetUtils.logEncoding(encoding));
        }
        encoding = CharsetUtils.normalizeCharset(encoding);
        return encoding;
    }

    public static String getEncoding(Message message, byte[] bytes, Logger logger) {
        String encoding = CharsetUtils.getHeaderCharset(message);
        if (encoding == null) {
            encoding = StreamUtils.detectEncoding((byte[])bytes);
            logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
            if (encoding == null) {
                encoding = EventHelper.getEncoding(message).toString();
                logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
            }
        }
        encoding = CharsetUtils.normalizeCharset(encoding);
        return encoding;
    }

    public static String getEncoding(Message message, Object input, Logger logger) throws IOException {
        String encoding = CharsetUtils.normalizeCharset(CharsetUtils.getHeaderCharset(message));
        if (encoding == null) {
            encoding = CharsetUtils.getEncoding(message.getPayload(), input, logger);
        }
        return encoding;
    }

    private static String normalizeCharset(String encoding) {
        if (encoding != null && encoding.matches("(?i)UTF-16.+")) {
            encoding = "UTF-16";
        }
        return encoding;
    }

    public static <T> String getEncoding(TypedValue<T> typedValue, Object input, Logger logger) throws IOException {
        String encoding = CharsetUtils.getEncoding(input, logger);
        if (encoding == null) {
            encoding = CharsetUtils.normalizeCharset(EventHelper.getEncoding(typedValue).toString());
            logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
        }
        return encoding;
    }

    public static String getEncoding(Object input, Logger logger) throws IOException {
        byte[] bytes = PayloadHelper.getPayloadAsByteArray(input);
        if (bytes == null) {
            return null;
        }
        String encoding = CharsetUtils.normalizeCharset(StreamUtils.detectEncoding((byte[])bytes));
        logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
        return encoding;
    }

    public static String getXmlEncoding(CoreEvent muleEvent, byte[] payload, Document document, Logger logger) {
        String encoding = document.getXmlEncoding();
        logger.debug("Xml declaration encoding: " + CharsetUtils.logEncoding(encoding));
        if (encoding == null) {
            encoding = StreamUtils.detectEncoding((byte[])payload);
            logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
        }
        if (encoding == null) {
            encoding = EventHelper.getEncoding(muleEvent).toString();
            logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
        }
        return encoding;
    }

    public static String getHeaderCharset(Message message) {
        return CharsetUtils.getCharset(AttributesHelper.getHeaderIgnoreCase((HttpRequestAttributes)message.getAttributes().getValue(), "Content-Type"));
    }

    public static String getCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        MediaType mediaType = MediaType.parse((String)contentType);
        Optional charset = mediaType.getCharset();
        return charset.map(Charset::name).orElse(null);
    }

    public static String getPayloadCharset(Message message, Logger logger) {
        Charset charset = message.getPayload().getDataType().getMediaType().getCharset().orElse(null);
        if (charset != null) {
            logger.debug("Request Payload charset: " + CharsetUtils.logEncoding(charset.toString()));
            return charset.toString();
        }
        return null;
    }

    public static byte[] trimBom(byte[] content) {
        int bomSize = 0;
        if (content.length > 4 && (content[0] == 0 && content[1] == 0 && content[2] == -2 && content[3] == -1 || content[0] == -1 && content[1] == -2 && content[2] == 0 && content[3] == 0)) {
            bomSize = 4;
        }
        if (content.length > 3 && bomSize == 0 && content[0] == -17 && content[1] == -69 && content[2] == -65) {
            bomSize = 3;
        }
        if (content.length > 2 && bomSize == 0 && (content[0] == -2 && content[1] == -1 || content[0] == -1 && content[1] == -2)) {
            bomSize = 2;
        }
        if (bomSize > 0) {
            LOGGER.debug("Trimming {}-byte BOM", (Object)bomSize);
            int trimmedSize = content.length - bomSize;
            byte[] trimmedArray = new byte[trimmedSize];
            System.arraycopy(content, bomSize, trimmedArray, 0, trimmedSize);
            return trimmedArray;
        }
        return content;
    }

    private static String logEncoding(String encoding) {
        return encoding != null ? encoding : "not specified";
    }
}

