/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.module.apikit.FlowMapping;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;

public class ApikitExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    public static final String EXTENSION_NAME = "APIKit";
    public static final String PREFIX_NAME = "apikit";
    public static final String EXTENSION_DESCRIPTION = "APIKit plugin";
    public static final String VENDOR = "Mulesoft";
    public static final String VERSION = "1.3.7-SNAPSHOT";
    public static final String XSD_FILE_NAME = "mule-apikit.xsd";
    private static final String UNESCAPED_LOCATION_PREFIX = "http://";
    private static final String SCHEMA_LOCATION = "www.mulesoft.org/schema/mule/mule-apikit";
    private static final String SCHEMA_VERSION = "current";
    protected final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        ErrorModel muleAnyErrorType = ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build();
        ErrorModel apikitAnyErrorType = ErrorModelBuilder.newError((String)"ANY", (String)"APIKIT").withParent(muleAnyErrorType).build();
        ErrorModel badRequestErrorModel = ErrorModelBuilder.newError((String)"BAD_REQUEST", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        ErrorModel notAcceptableErrorModel = ErrorModelBuilder.newError((String)"NOT_ACCEPTABLE", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        ErrorModel unsupportedMediaTypeErrorModel = ErrorModelBuilder.newError((String)"UNSUPPORTED_MEDIA_TYPE", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        ErrorModel methodNotAllowedErrorModel = ErrorModelBuilder.newError((String)"METHOD_NOT_ALLOWED", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        ErrorModel notFoundErrorModel = ErrorModelBuilder.newError((String)"NOT_FOUND", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        ErrorModel notImplementedErrorModel = ErrorModelBuilder.newError((String)"NOT_IMPLEMENTED", (String)"APIKIT").withParent(apikitAnyErrorType).build();
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX_NAME).setXsdFileName(XSD_FILE_NAME).setSchemaVersion(VERSION).setSchemaLocation(String.format("%s/%s/%s", "http://www.mulesoft.org/schema/mule/mule-apikit", SCHEMA_VERSION, XSD_FILE_NAME)).setNamespace("http://www.mulesoft.org/schema/mule/mule-apikit").build();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        extensionDeclarer.named(EXTENSION_NAME).describedAs(EXTENSION_DESCRIPTION).fromVendor(VENDOR).onVersion(VERSION).withCategory(Category.COMMUNITY).withXmlDsl(xmlDslModel).withErrorModel(badRequestErrorModel).withErrorModel(apikitAnyErrorType).withErrorModel(notAcceptableErrorModel).withErrorModel(unsupportedMediaTypeErrorModel).withErrorModel(methodNotAllowedErrorModel).withErrorModel(notFoundErrorModel).withErrorModel(notImplementedErrorModel);
        extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)typeLoader.load(HttpRequestAttributes.class)));
        ConfigurationDeclarer apikitConfig = extensionDeclarer.withConfig("config").describedAs(PREFIX_NAME);
        ParameterGroupDeclarer parameterGroupDeclarer = apikitConfig.onDefaultParameterGroup();
        parameterGroupDeclarer.withOptionalParameter("raml").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("api").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withRequiredParameter("outboundHeadersMapName").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withRequiredParameter("httpStatusVarName").ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("keepApiBaseUri").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("keepRamlBaseUri").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("disableValidations").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("queryParamsStrictValidation").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("headersStrictValidation").defaultingTo((Object)false).ofType(typeLoader.load(String.class));
        parameterGroupDeclarer.withOptionalParameter("parser").defaultingTo((Object)ParserMode.AUTO).ofType(typeLoader.load(ParserMode.class));
        parameterGroupDeclarer.withOptionalParameter("flowMappings").ofType((MetadataType)this.typeBuilder.arrayType().of(typeLoader.load(FlowMapping.class)).build());
        OperationDeclarer routerDeclarer = apikitConfig.withOperation("router");
        routerDeclarer.withOutputAttributes().ofType(typeLoader.load(HttpRequestAttributes.class));
        routerDeclarer.withOutput().ofType(typeLoader.load(Object.class));
        ((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)routerDeclarer.withErrorModel(badRequestErrorModel)).withErrorModel(notAcceptableErrorModel)).withErrorModel(unsupportedMediaTypeErrorModel)).withErrorModel(methodNotAllowedErrorModel)).withErrorModel(notFoundErrorModel);
        OperationDeclarer consoleDeclarer = apikitConfig.withOperation("console");
        consoleDeclarer.withOutputAttributes().ofType(typeLoader.load(HttpRequestAttributes.class));
        consoleDeclarer.withOutput().ofType(typeLoader.load(Object.class));
        consoleDeclarer.withErrorModel(notFoundErrorModel);
    }
}

