/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.HashMap;
import org.mule.apikit.model.Action;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.HeadersValidator;
import org.mule.module.apikit.validation.attributes.QueryParameterValidator;
import org.mule.module.apikit.validation.attributes.QueryStringValidator;
import org.mule.module.apikit.validation.attributes.UriParametersValidator;
import org.mule.module.apikit.validation.attributes.ValidatedQueryParams;
import org.mule.runtime.api.util.MultiMap;

public class AttributesValidator {
    public static HttpRequestAttributes validateAndAddDefaults(HttpRequestAttributes attributes, Action action, ResolvedVariables resolvedVariables, ValidationConfig config) throws MuleRestException {
        UriParametersValidator.validate(action.getResolvedUriParameters(), resolvedVariables);
        QueryStringValidator.validate(action.queryString(), (MultiMap<String, String>)attributes.getQueryParams());
        ValidatedQueryParams validatedQueryParams = QueryParameterValidator.validate(action.getQueryParameters(), (MultiMap<String, String>)attributes.getQueryParams(), attributes.getQueryString(), config.isQueryParamsStrictValidation());
        MultiMap<String, String> queryParams = validatedQueryParams.getQueryParams();
        String queryString = validatedQueryParams.getQueryString();
        MultiMap<String, String> headers = HeadersValidator.validateAndAddDefaults(action.getHeaders(), action.getResponses(), (MultiMap<String, String>)attributes.getHeaders(), config.isHeadersStrictValidation());
        HashMap<String, String> uriParamsMap = new HashMap<String, String>();
        resolvedVariables.names().forEach(name -> uriParamsMap.put((String)name, String.valueOf(resolvedVariables.get((String)name))));
        return AttributesHelper.replaceParams(attributes, headers, queryParams, queryString, uriParamsMap);
    }
}

