/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.Resource;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.ApikitRegistry;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.api.FlowUtils;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.InvalidUriParameterException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.spi.AbstractRouter;
import org.mule.module.apikit.api.spi.RouterService;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.RequestValidator;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.ConfigURLMapping;
import org.mule.module.apikit.routing.DefaultFlowRoutingStrategy;
import org.mule.module.apikit.routing.FlowRoutingStrategy;
import org.mule.module.apikit.routing.PrivilegedFlowRoutingStrategy;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.utils.MuleVersionUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class Router
extends AbstractComponent
implements Processor,
Initialisable,
AbstractRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Router.class);
    @Inject
    private MuleContext muleContext;
    private final ApikitRegistry registry;
    private final ConfigurationComponentLocator locator;
    private FlowRoutingStrategy routingStrategy;
    private Configuration configuration;
    private String name;
    @Inject
    private StreamingManager streamingManager;
    private CursorStreamProviderFactory streamProviderFactory;

    @Inject
    public Router(ApikitRegistry registry, ConfigurationComponentLocator locator) {
        this.registry = registry;
        this.locator = locator;
    }

    public void initialise() {
        String name = this.getLocation().getRootContainerName();
        Optional<URI> url = FlowUtils.getSourceLocation(this.locator, name);
        this.routingStrategy = this.getRoutingStrategy();
        if (!url.isPresent()) {
            LOGGER.error("There was an error retrieving Api Source. Console will work only if the keepApiBaseUri property is set to true.");
        } else {
            String configName = this.configuration.getName();
            this.registry.setApiSource(configName, url.get().toString().replace("*", ""));
            ConfigURLMapping.INSTANCE.registerConfigURL(configName, url.get().toString().replace("*", ""));
            LOGGER.info(StringMessageUtils.getBoilerPlate((String)("APIKit Router '" + configName + "' started using Parser: " + this.configuration.getType())));
        }
        this.streamProviderFactory = this.streamingManager.forBytes().getDefaultCursorProviderFactory();
    }

    private FlowRoutingStrategy getRoutingStrategy() {
        return MuleVersionUtils.isAtLeast("4.2.0") ? new DefaultFlowRoutingStrategy() : new PrivilegedFlowRoutingStrategy(this.getLocation());
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return MessageProcessors.flatMap(publisher, this::processWithExtension, (Component)this);
    }

    @Override
    public ApiSpecification getRaml() {
        return this.getConfiguration().getRamlHandler().getApi();
    }

    private Publisher<CoreEvent> processWithExtension(CoreEvent event) {
        try {
            Optional<RouterService> extension = this.configuration.getExtension();
            if (extension.isPresent()) {
                return extension.get().process(event, this);
            }
            return this.processEvent(event);
        }
        catch (MuleRestException e) {
            return Mono.error((Throwable)ApikitErrorTypes.throwErrorType(e, ApikitErrorTypes.errorRepositoryFrom(this.muleContext)));
        }
        catch (MuleException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Publisher<CoreEvent> processEvent(CoreEvent event) throws MuleRestException {
        Configuration config = this.registry.getConfiguration(this.getConfiguration().getName());
        HttpRequestAttributes attributes = (HttpRequestAttributes)event.getMessage().getAttributes().getValue();
        return this.doRoute(event, config, attributes);
    }

    private Publisher<CoreEvent> doRoute(CoreEvent mainEvent, Configuration config, HttpRequestAttributes attributes) throws MuleRestException {
        String path = this.getRequestPath(attributes);
        URIPattern uriPattern = this.findInCache(path, config.getUriPatternCache());
        URIResolver uriResolver = this.findInCache(path, config.getUriResolverCache());
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        Resource resource = config.getFlowFinder().getResource(uriPattern);
        TypedValue payload = mainEvent.getMessage().getPayload();
        ValidRequest request = RequestValidator.validate(config, resource, attributes, resolvedVariables, this.makeInputBodyRepeatable(config.isDisableValidations(), mainEvent, (TypedValue<Object>)payload), ApikitErrorTypes.errorRepositoryFrom(this.muleContext));
        Flow flow = config.getFlowFinder().getFlow(resource, attributes.getMethod().toLowerCase(), AttributesHelper.getContentType((MultiMap<String, String>)attributes.getHeaders()));
        CoreEvent subFlowEvent = this.buildSubFlowEvent(config.isDisableValidations(), mainEvent, request, config.getOutboundHeadersMapName());
        return Mono.from(this.routingStrategy.route(flow, mainEvent, subFlowEvent)).map(result -> {
            if (result.getVariables().get(config.getHttpStatusVarName()) == null) {
                RamlHandler handler = config.getRamlHandler();
                String successStatusCode = handler.getSuccessStatusCode(resource.getAction(attributes.getMethod().toLowerCase()));
                return CoreEvent.builder((CoreEvent)result).addVariable(config.getHttpStatusVarName(), (Object)successStatusCode).build();
            }
            return result;
        });
    }

    private String getRequestPath(HttpRequestAttributes attributes) throws BadRequestException {
        try {
            String rawRequestPath = URICoder.encodeRequestPath(attributes.getRawRequestPath());
            String path = UrlUtils.getRelativePath(attributes.getListenerPath(), rawRequestPath);
            return path.isEmpty() ? "/" : path;
        }
        catch (ApikitRuntimeException e) {
            throw new InvalidUriParameterException(e.getMessage());
        }
    }

    private <T> T findInCache(String key, LoadingCache<String, T> cache) {
        try {
            return (T)cache.get((Object)key);
        }
        catch (Exception e) {
            throw ApikitErrorTypes.throwErrorType(new NotFoundException(key), ApikitErrorTypes.errorRepositoryFrom(this.muleContext));
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private CoreEvent buildSubFlowEvent(boolean disableValidations, CoreEvent parent, ValidRequest request, String outboundHeadersMapName) {
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)parent);
        eventBuilder.addVariable(outboundHeadersMapName, new HashMap());
        Message.Builder messageBuilder = Message.builder((Message)parent.getMessage());
        messageBuilder.value(this.makeRepeatable(disableValidations, request.getBody().getPayload(), parent));
        messageBuilder.attributesValue((Object)request.getAttributes());
        return eventBuilder.message(messageBuilder.build()).build();
    }

    private TypedValue<Object> makeInputBodyRepeatable(boolean disableValidations, CoreEvent event, TypedValue<Object> inputBody) {
        return new TypedValue(this.makeRepeatable(disableValidations, inputBody.getValue(), event), inputBody.getDataType(), inputBody.getByteLength());
    }

    private Object makeRepeatable(boolean disableValidations, Object body, CoreEvent event) {
        try {
            if (disableValidations) {
                return body;
            }
            return body instanceof InputStream && ((InputStream)body).available() > 0 ? this.streamProviderFactory.of(event.getContext(), (Object)((InputStream)body)) : body;
        }
        catch (IOException e) {
            return body;
        }
    }
}

