/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import java.util.Map;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidUriParameterException;
import org.mule.module.apikit.api.uri.ResolvedVariables;

public class UriParametersValidator {
    private final Action action;

    public UriParametersValidator(Action action) {
        this.action = action;
    }

    public void validate(ResolvedVariables resolvedVariables) throws InvalidUriParameterException {
        for (Map.Entry entry : this.action.getResolvedUriParameters().entrySet()) {
            String value = (String)resolvedVariables.get((String)entry.getKey());
            Parameter uriParameter = (Parameter)entry.getValue();
            if (uriParameter.validate(value)) continue;
            String msg = String.format("Invalid value '%s' for uri parameter %s. %s", value, entry.getKey(), uriParameter.message(value));
            throw new InvalidUriParameterException(msg);
        }
    }
}

