/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;

public class MultipartFormData {
    private final HttpEntity multipartFormEntity;

    public MultipartFormData(HttpEntity multipartFormEntity) {
        this.multipartFormEntity = multipartFormEntity;
    }

    public InputStream getInputStream() throws InvalidFormParameterException {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.multipartFormEntity.writeTo((OutputStream)outStream);
            outStream.flush();
            return new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    public long getLength() {
        return this.multipartFormEntity.getContentLength();
    }

    public String getContentType() {
        return this.multipartFormEntity.getContentType().getValue();
    }
}

