/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalLong;
import org.apache.http.HttpEntity;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;

public class MultipartWithDefaults
implements Multipart {
    private final byte[] preamble;
    private final byte[] epilogue;
    private final HttpEntity multipartFormEntity;
    private final long contentLength;

    public MultipartWithDefaults(HttpEntity multipartFormEntity, byte[] preamble, byte[] epilogue, long contentLength) {
        this.preamble = preamble;
        this.epilogue = epilogue;
        this.multipartFormEntity = multipartFormEntity;
        this.contentLength = contentLength;
    }

    @Override
    public InputStream content() throws InvalidFormParameterException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)this.contentLength);
            this.multipartFormEntity.writeTo((OutputStream)byteArrayOutputStream);
            byte[] rawContent = byteArrayOutputStream.toByteArray();
            return new ByteArrayInputStream(ByteBuffer.allocate((int)this.contentLength).put(this.preamble).put(rawContent, 0, rawContent.length - StreamUtils.CRLF.length).put(this.epilogue).array());
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
    }

    @Override
    public String contentType() {
        return this.multipartFormEntity.getContentType().getValue();
    }

    @Override
    public OptionalLong getLength() {
        return OptionalLong.of(this.contentLength);
    }
}

