/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.mule.module.apikit.validation.body.schema.v1.io.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestJsonSchemaValidator
implements IRestSchemaValidatorStrategy {
    private static final String JSON_SCHEMA_FAIL_ON_WARNING_KEY = "raml.json_schema.fail_on_warning";
    protected static final Logger logger = LoggerFactory.getLogger(RestJsonSchemaValidator.class);
    private JsonSchema jsonSchema;

    public RestJsonSchemaValidator(JsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    @Override
    public void validate(String payload) throws BadRequestException {
        if (this.jsonSchema != null) {
            ProcessingReport report;
            try {
                boolean isEmpty = StringUtils.isEmpty((CharSequence)payload);
                JsonNode data = JsonUtils.parseJson(new StringReader(isEmpty ? "null" : payload));
                report = this.jsonSchema.validate(data, true);
            }
            catch (ProcessingException | IOException e) {
                throw new BadRequestException(e);
            }
            Iterator iterator = report.iterator();
            StringBuilder messageBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                ProcessingMessage next = (ProcessingMessage)iterator.next();
                LogLevel logLevel = next.getLogLevel();
                String logMessage = next.toString();
                boolean failOnWarning = Boolean.valueOf(System.getProperty(JSON_SCHEMA_FAIL_ON_WARNING_KEY, "false"));
                if (!logLevel.equals((Object)LogLevel.ERROR) && (!logLevel.equals((Object)LogLevel.WARNING) || !failOnWarning)) continue;
                messageBuilder.append(logMessage).append("\n");
            }
            if (messageBuilder.length() > 0) {
                String message = messageBuilder.toString();
                logger.info("Schema validation failed: " + message);
                throw new BadRequestException(message);
            }
        }
    }
}

