/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.apikit.ApiType;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.loader.ApiSyncResourceLoader;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiReference;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.parser.service.ParserMode;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.result.ParsingIssue;
import org.mule.parser.service.result.UnsupportedParsingIssue;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.raml.model.ActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlHandler {
    private Pattern CONSOLE_RESOURCE_PATTERN = Pattern.compile(".*console-resources.*(html|json|js)");
    public static final String APPLICATION_RAML = "application/raml+yaml";
    private static final Logger LOGGER = LoggerFactory.getLogger(RamlHandler.class);
    private static final String RAML_QUERY_STRING = "raml";
    private String apiResourcesRelativePath = "";
    private boolean keepApiBaseUri;
    private String apiServer;
    private ApiSpecification api;
    private ErrorTypeRepository errorTypeRepository;
    private List<String> acceptedClasspathResources;

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository) throws IOException {
        this(null, ramlLocation, keepApiBaseUri, errorTypeRepository, null);
    }

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository, ParserMode parserMode) throws IOException {
        this(null, ramlLocation, keepApiBaseUri, errorTypeRepository, parserMode);
    }

    public RamlHandler(ScheduledExecutorService executor, String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository, ParserMode parserMode) throws IOException {
        this(executor, ramlLocation, keepApiBaseUri, errorTypeRepository, parserMode, false);
    }

    public RamlHandler(ScheduledExecutorService executor, String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository, ParserMode parserMode, boolean filterUnsupportedLogging) throws IOException {
        ParserService parserService = new ParserService(executor);
        this.keepApiBaseUri = keepApiBaseUri;
        String rootRamlLocation = this.findRootRaml(ramlLocation);
        if (rootRamlLocation == null) {
            throw new IOException("Raml not found at: " + ramlLocation);
        }
        ApiReference apiReference = ApiReference.create((String)rootRamlLocation);
        ParseResult result = parserService.parse(apiReference, parserMode == null ? ParserMode.AUTO : parserMode);
        if (result.success()) {
            this.logWarnings(result.getWarnings(), filterUnsupportedLogging);
            this.api = result.get();
            int idx = rootRamlLocation.lastIndexOf("/");
            if (idx > 0) {
                this.apiResourcesRelativePath = rootRamlLocation.substring(0, idx + 1);
                this.apiResourcesRelativePath = this.uriPathToResourcePath(this.apiResourcesRelativePath);
            } else if (ApiSyncUtils.isSyncProtocol((String)rootRamlLocation)) {
                this.apiResourcesRelativePath = rootRamlLocation;
            }
        } else {
            String errors = result.getErrors().stream().map(e -> "  - " + e.cause()).collect(Collectors.joining(" \n"));
            throw new RuntimeException("Errors while parsing RAML file in [" + parserMode + "] mode: \n" + errors);
        }
        this.acceptedClasspathResources = this.getAcceptedClasspathResources(this.api, this.apiResourcesRelativePath);
        this.errorTypeRepository = errorTypeRepository;
    }

    private void logWarnings(List<ParsingIssue> parsingIssues, boolean filterUnsupportedLogging) {
        if (CollectionUtils.isNotEmpty(parsingIssues)) {
            LOGGER.warn(StringMessageUtils.getBoilerPlate((String)this.getFilteredParsingIssueStream(parsingIssues, filterUnsupportedLogging).map(e -> "  - " + e.cause()).collect(Collectors.joining(" \n"))));
        }
    }

    private Stream<ParsingIssue> getFilteredParsingIssueStream(List<ParsingIssue> parsingIssues, boolean filterUnsupportedLogging) {
        return parsingIssues.stream().filter(issue -> !(issue instanceof UnsupportedParsingIssue) || issue instanceof UnsupportedParsingIssue && !filterUnsupportedLogging);
    }

    private List<String> getAcceptedClasspathResources(ApiSpecification api, String apiResourcesRelativePath) {
        return api.getAllReferences().stream().map(ref -> {
            try {
                return Paths.get(new URI((String)ref)).toString();
            }
            catch (Exception e) {
                return ref;
            }
        }).map(ref -> {
            int index = ref.indexOf(apiResourcesRelativePath);
            return index > 0 ? ref.substring(index) : ref;
        }).collect(Collectors.toList());
    }

    @Deprecated
    public boolean isParserV2() {
        ApiType parser = this.api.getType();
        return parser == ApiType.AMF || parser == ApiType.RAML && ApiVendor.RAML_10 == this.getApiVendor();
    }

    public ApiVendor getApiVendor() {
        return this.api.getApiVendor();
    }

    public ApiSpecification getApi() {
        return this.api;
    }

    public void setApi(ApiSpecification api) {
        this.api = api;
    }

    public String dumpRaml() {
        return this.api.dump(null);
    }

    public String getRamlV1() {
        if (this.keepApiBaseUri) {
            return this.dumpRaml();
        }
        String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
        return this.api.dump(baseUriReplacement);
    }

    public String getRamlV2(String resourceRelativePath) throws TypedException {
        String resourcePath = this.uriPathToResourcePath(resourceRelativePath);
        Path normalizedPath = Paths.get(resourcePath, new String[0]).normalize();
        if (normalizedPath.getNameCount() >= 1) {
            InputStream apiResource;
            ByteArrayOutputStream baos;
            block11: {
                Object classpathResouce;
                String normalized = normalizedPath.toString();
                if (this.apiResourcesRelativePath.equals(normalized)) {
                    String rootRaml = this.dumpRaml();
                    if (!this.keepApiBaseUri) {
                        String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
                        return UrlUtils.replaceBaseUri(rootRaml, baseUriReplacement);
                    }
                    return rootRaml;
                }
                baos = new ByteArrayOutputStream();
                apiResource = null;
                try {
                    if (ApiSyncUtils.isSyncProtocol((String)this.apiResourcesRelativePath)) {
                        ApiSyncResourceLoader loader = new ApiSyncResourceLoader(this.apiResourcesRelativePath);
                        apiResource = loader.getResourceAsStream(normalized.substring(this.apiResourcesRelativePath.length()));
                    } else {
                        classpathResouce = Thread.currentThread().getContextClassLoader().getResource(normalized.replace("\\", "/"));
                        if (classpathResouce != null) {
                            String path = ((URL)classpathResouce).getPath();
                            if (this.CONSOLE_RESOURCE_PATTERN.asPredicate().test(path) || this.acceptedClasspathResources.stream().anyMatch(cr -> path.endsWith(cr.replace("\\", "/"))) || path.endsWith(this.api.getLocation())) {
                                apiResource = ((URL)classpathResouce).openStream();
                            }
                        }
                    }
                    if (apiResource == null) break block11;
                    StreamUtils.copyLarge(apiResource, baos);
                    classpathResouce = baos.toString();
                }
                catch (IOException e) {
                    try {
                        LOGGER.debug(e.getMessage());
                        throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(apiResource);
                        IOUtils.closeQuietly((OutputStream)baos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)apiResource);
                IOUtils.closeQuietly((OutputStream)baos);
                return classpathResouce;
            }
            IOUtils.closeQuietly((InputStream)apiResource);
            IOUtils.closeQuietly((OutputStream)baos);
        }
        throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
    }

    public String getAMFModel() {
        try {
            return this.replaceUriInAMFModel(this.apiServer).dumpAmf();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public synchronized void writeAMFModel(String url, OutputStream outputStream) {
        this.replaceUriInAMFModel(url).writeAMFModel(outputStream);
    }

    private AMFImpl replaceUriInAMFModel(String url) throws IllegalStateException {
        if (!ApiType.AMF.equals((Object)this.api.getType())) {
            throw new IllegalStateException("Trying to return AMF Model when RAML-Parser is being used");
        }
        AMFImpl amfApiSpec = (AMFImpl)this.api;
        if (!this.keepApiBaseUri) {
            String baseUriReplacement = this.getBaseUriReplacement(url);
            amfApiSpec.updateBaseUri(baseUriReplacement);
        }
        return amfApiSpec;
    }

    public String getBaseUriReplacement(String apiServer) {
        return UrlUtils.getBaseUriReplacement(apiServer);
    }

    public boolean isRequestingRamlV1ForConsole(String listenerPath, String requestPath, String queryString, String method, String acceptHeader) {
        String postalistenerPath = UrlUtils.getListenerPath(listenerPath, requestPath);
        return !(!this.getApiVendor().equals((Object)ApiVendor.RAML_08) || !postalistenerPath.equals(requestPath) && !(postalistenerPath + "/").equals(requestPath) || !ActionType.GET.toString().equals(method.toUpperCase()) || !APPLICATION_RAML.equals(acceptHeader) && !queryString.equals(RAML_QUERY_STRING));
    }

    public boolean isRequestingRamlV2(String listenerPath, String requestPath, String queryString, String method) {
        String consolePath;
        String resourcesFullPath = consolePath = UrlUtils.getListenerPath(listenerPath, requestPath);
        if (!consolePath.endsWith("/")) {
            if (!this.apiResourcesRelativePath.startsWith("/")) {
                resourcesFullPath = resourcesFullPath + "/";
            }
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath;
        } else if (this.apiResourcesRelativePath.startsWith("/") && this.apiResourcesRelativePath.length() > 1) {
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath.substring(1);
        }
        return this.getApiVendor().equals((Object)ApiVendor.RAML_10) && queryString.equals(RAML_QUERY_STRING) && ActionType.GET.toString().equals(method.toUpperCase()) && requestPath.startsWith(resourcesFullPath);
    }

    private String uriPathToResourcePath(String resourceRelativePath) {
        if (resourceRelativePath.startsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(1);
        }
        if (resourceRelativePath.contains("?raml")) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.lastIndexOf(63));
        }
        if (resourceRelativePath.endsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.length() - 1);
        }
        return Paths.get(resourceRelativePath, new String[0]).toString();
    }

    private String findRootRaml(String ramlLocation) {
        try {
            URL url = new URL(ramlLocation);
            return url.toString();
        }
        catch (MalformedURLException e) {
            String[] startingLocations;
            for (String start : startingLocations = new String[]{"api/", "", "api"}) {
                URL ramlLocationUrl = Thread.currentThread().getContextClassLoader().getResource(start + ramlLocation);
                if (ramlLocationUrl == null) continue;
                return start + ramlLocation;
            }
            return null;
        }
    }

    public String getRootRamlLocationForV2() {
        return "this.location.href + '" + this.apiResourcesRelativePath + "/?" + RAML_QUERY_STRING + "'";
    }

    public String getRootRamlLocationForV1() {
        return "this.location.href + '?raml'";
    }

    public String getSuccessStatusCode(Action action) {
        return action.getSuccessStatusCode();
    }

    public void setApiServer(String apiServer) {
        this.apiServer = apiServer;
    }
}

