/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.Resource;
import org.mule.module.apikit.api.uri.URIPattern;

public class RoutingTable {
    protected Map<URIPattern, Resource> routingTable = new HashMap<URIPattern, Resource>();

    public RoutingTable(ApiSpecification api) {
        this.buildRoutingTable(api.getResources(), api.getVersion());
    }

    private void buildRoutingTable(Map<String, Resource> resources, String version) {
        for (Resource resource : resources.values()) {
            if (!resource.getActions().isEmpty()) {
                String uri = resource.getResolvedUri(version);
                this.routingTable.put(new URIPattern(uri), resource);
            }
            if (resource.getResources() == null) continue;
            this.buildRoutingTable(resource.getResources(), version);
        }
    }

    public Resource getResource(String uri) {
        return this.routingTable.get(new URIPattern(uri));
    }

    public Resource getResource(URIPattern uriPattern) {
        return this.routingTable.get(uriPattern);
    }

    public Set<URIPattern> keySet() {
        return this.routingTable.keySet();
    }
}

