/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v2;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSchemaV2Validator
implements IRestSchemaValidatorStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(RestSchemaV2Validator.class);
    private MimeType mimeType;

    public RestSchemaV2Validator(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public void validate(String payload) throws BadRequestException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<List> future = executor.submit(() -> this.mimeType.validate(payload));
        try {
            List validationResults = future.get(2L, TimeUnit.SECONDS);
            if (!validationResults.isEmpty()) {
                throw new BadRequestException(this.buildLogMessage(validationResults));
            }
        }
        catch (TimeoutException e) {
            throw new BadRequestException("Validation timed out after 2 seconds");
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BadRequestException("Error during validation: " + e.getMessage());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String buildLogMessage(List<ApiValidationResult> validationResults) {
        return validationResults.stream().map(result -> result.getMessage().replace("\n", "")).collect(Collectors.joining("\n"));
    }
}

