/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;
import org.mule.module.apikit.api.deserializing.AttributesDeserializingStrategies;
import org.mule.module.apikit.api.exception.InvalidHeaderException;
import org.mule.module.apikit.deserializing.AttributeDeserializer;
import org.mule.module.apikit.deserializing.AttributesDeserializerFactory;
import org.mule.module.apikit.deserializing.AttributesDeserializingStrategyIdentifier;
import org.mule.module.apikit.deserializing.MimeType;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersValidator.class);
    private static final String PLACEHOLDER_TOKEN = "{?}";

    public static MultiMap<String, String> validateAndAddDefaults(Map<String, Parameter> headers, Map<String, Response> responses, String successStatusCode, MultiMap<String, String> incomingHeaders, boolean headersStrictValidation, AttributesDeserializingStrategies attributesDeserializingStrategy) throws InvalidHeaderException, NotAcceptableException {
        MultiMap<String, String> headersWithDefaults = HeadersValidator.analyseRequestHeaders(headers, incomingHeaders, headersStrictValidation, attributesDeserializingStrategy);
        HeadersValidator.analyseAcceptHeader(responses, successStatusCode, headersWithDefaults);
        return headersWithDefaults;
    }

    private static MultiMap<String, String> analyseRequestHeaders(Map<String, Parameter> headers, MultiMap<String, String> incomingHeaders, boolean headersStrictValidation, AttributesDeserializingStrategies attributesDeserializingStrategy) throws InvalidHeaderException {
        if (headersStrictValidation) {
            HeadersValidator.validateHeadersStrictly(headers, incomingHeaders);
        }
        MultiMap<String, String> copyIncomingHeaders = MultiMap.emptyMultiMap();
        for (Map.Entry<String, Parameter> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            Parameter headerType = entry.getValue();
            if (headerName.contains(PLACEHOLDER_TOKEN)) {
                HeadersValidator.validateHeadersWithPlaceholderToken(incomingHeaders, headerName, headerType);
                continue;
            }
            List<String> values = AttributesHelper.getParamValues(incomingHeaders, headerName);
            if (values.isEmpty() && headerType.isRequired()) {
                throw new InvalidHeaderException("Required header '" + headerName + "' not specified");
            }
            List defaultValues = headerType.getDefaultValues();
            if (values.isEmpty() && !defaultValues.isEmpty()) {
                copyIncomingHeaders = HeadersValidator.getMutableCopy(incomingHeaders, copyIncomingHeaders);
                for (String defaultValue : defaultValues) {
                    copyIncomingHeaders.put((Object)headerName, (Object)defaultValue);
                }
            }
            if (!values.isEmpty() && headerType.isArray()) {
                values = HeadersValidator.deserializeValues(values, attributesDeserializingStrategy);
                copyIncomingHeaders = HeadersValidator.getMutableCopy(incomingHeaders, copyIncomingHeaders);
                copyIncomingHeaders.removeAll((Object)headerName.toLowerCase());
                copyIncomingHeaders.removeAll((Object)headerName);
                copyIncomingHeaders.put((Object)headerName, values);
            }
            HeadersValidator.validateHeader(values, headerName, headerType);
        }
        return copyIncomingHeaders.isEmpty() ? incomingHeaders : copyIncomingHeaders;
    }

    private static MultiMap<String, String> getMutableCopy(MultiMap<String, String> incomingHeaders, MultiMap<String, String> copyIncomingHeaders) {
        if (copyIncomingHeaders.isEmpty()) {
            return AttributesHelper.copyImmutableMap(incomingHeaders);
        }
        return copyIncomingHeaders;
    }

    private static void validateHeadersWithPlaceholderToken(MultiMap<String, String> copyIncomingHeaders, String headerName, Parameter headerType) throws InvalidHeaderException {
        String regex = headerName.replace(PLACEHOLDER_TOKEN, ".*");
        for (String incomingHeader : copyIncomingHeaders.keySet()) {
            if (!incomingHeader.matches(regex)) continue;
            HeadersValidator.validateHeader(copyIncomingHeaders.getAll((Object)incomingHeader), headerName, headerType);
        }
    }

    private static void validateHeadersStrictly(Map<String, Parameter> headers, Map<String, String> incomingHeaders) throws InvalidHeaderException {
        Set standardHeaders;
        Set specHeaders = headers.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Set templateHeaders = specHeaders.stream().filter(header -> header.contains(PLACEHOLDER_TOKEN)).map(header -> header.replace(PLACEHOLDER_TOKEN, ".*")).collect(Collectors.toSet());
        Set unmatchedHeaders = incomingHeaders.keySet().stream().filter(header -> templateHeaders.stream().noneMatch(header::matches)).collect(Collectors.toSet());
        Sets.SetView undefinedHeaders = Sets.difference(unmatchedHeaders, (Set)Sets.union(specHeaders, standardHeaders = Arrays.stream(HeaderName.values()).map(header -> header.getName().toLowerCase()).collect(Collectors.toSet())));
        if (!undefinedHeaders.isEmpty()) {
            throw new InvalidHeaderException(String.format("[%s] %s", Joiner.on((String)", ").join((Iterable)undefinedHeaders), "headers are not defined in API spec and strict headers validation property is true."));
        }
    }

    private static void validateHeader(List<String> values, String name, Parameter type) throws InvalidHeaderException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() > 1 && !type.isArray() && !type.isRepeat()) {
            throw new InvalidHeaderException("Header " + name + " is not repeatable");
        }
        if (type.isArray()) {
            HeadersValidator.validateTypeArrayValues(name, values, type);
        } else {
            HeadersValidator.validateTypeValue(name, values.get(0), type);
        }
    }

    private static List<String> deserializeValues(List<String> listOfDelimitedValues, AttributesDeserializingStrategies deserializingStrategies) {
        AttributeDeserializer deserializer = AttributesDeserializerFactory.INSTANCE.getDeserializer(AttributesDeserializingStrategyIdentifier.ARRAY_HEADER_DESERIALIZING_STRATEGY, deserializingStrategies);
        return deserializer.deserializeListOfValues(listOfDelimitedValues);
    }

    private static void validateTypeArrayValues(String name, List<String> values, Parameter type) throws InvalidHeaderException {
        if (!type.validateArray(values)) {
            throw new InvalidHeaderException(String.format("Invalid values '%s' for header '%s'", values.stream().collect(Collectors.joining(",")), name));
        }
    }

    private static void validateTypeValue(String name, String value, Parameter type) throws InvalidHeaderException {
        if (!type.validate(value)) {
            throw new InvalidHeaderException(String.format("Invalid value '%s' for header '%s'", value, name));
        }
    }

    private static void analyseAcceptHeader(Map<String, Response> responses, String successStatusCode, MultiMap<String, String> incomingHeaders) throws NotAcceptableException {
        if (MapUtils.isEmpty(responses)) {
            return;
        }
        List<String> mimeTypes = HeadersValidator.getResponseMimeTypes(responses, successStatusCode);
        if (CollectionUtils.isEmpty(mimeTypes)) {
            return;
        }
        if (!HeadersValidator.someRepresentationIsSupported(mimeTypes, AttributesHelper.getAcceptedResponseMediaTypes(incomingHeaders))) {
            throw new NotAcceptableException();
        }
    }

    private static List<String> getResponseMimeTypes(Map<String, Response> responses, String successStatusCode) {
        Response response = responses.get(successStatusCode);
        if (response != null && response.hasBody()) {
            return new ArrayList<String>(response.getBody().keySet());
        }
        return new ArrayList<String>();
    }

    public static boolean someRepresentationIsSupported(List<String> supportedRepresentations, String header) {
        List<MimeType> parseResults;
        try {
            parseResults = MimeType.listFrom(header, ArrayHeaderDelimiter.COMMA.getDelimiterChar());
        }
        catch (MimeType.MimeTypeParseException e) {
            LOGGER.warn("Failed to parse user-provided MimeType list: {}", (Object)header, (Object)e);
            return false;
        }
        return supportedRepresentations.stream().flatMap(representation -> {
            try {
                return Stream.of(MimeType.from(representation));
            }
            catch (MimeType.MimeTypeParseException e) {
                LOGGER.warn("Failed to parse application-provided MimeType: {}", representation, (Object)e);
                return Stream.empty();
            }
        }).anyMatch(supported -> parseResults.stream().anyMatch(expected -> HeadersValidator.isCompatible(expected, supported)));
    }

    private static boolean isCompatible(MimeType expected, MimeType supported) {
        return HeadersValidator.isCompatible(expected.getType(), supported.getType()) && HeadersValidator.isCompatible(expected.getSubtype(), supported.getSubtype());
    }

    private static boolean isCompatible(String expected, String supported) {
        return expected.equalsIgnoreCase(supported) || "*".equals(expected);
    }
}

