/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.uri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.Variable;
import org.mule.module.apikit.uri.VariableBinder;
import org.mule.module.apikit.uri.VariableResolver;

public class URIResolver {
    private String _uri;

    public URIResolver(String uri, boolean encode) {
        if (encode) {
            uri = this.encode(uri);
        }
        this._uri = uri;
    }

    public URIResolver(String uri) {
        this(uri, true);
    }

    private String encode(String uri) {
        return URICoder.encode(uri, '/');
    }

    public String uri() {
        return this._uri;
    }

    public URIPattern find(Set<URIPattern> patterns) {
        return this.findFirst(patterns);
    }

    public URIPattern find(Set<URIPattern> patterns, MatchRule rule) {
        switch (rule) {
            case FIRST_MATCH: {
                return this.findFirst(patterns);
            }
            case BEST_MATCH: {
                return this.findBest(patterns);
            }
        }
        return null;
    }

    public Collection<URIPattern> findAll(Set<URIPattern> patterns) {
        ArrayList<URIPattern> matches = new ArrayList<URIPattern>();
        if (patterns == null || patterns.size() == 0) {
            return matches;
        }
        for (URIPattern p : patterns) {
            if (!p.match(this._uri)) continue;
            matches.add(p);
        }
        return matches;
    }

    public URIResolveResult resolve(URIPattern pattern) {
        return this.resolve(pattern, new VariableBinder());
    }

    public URIResolveResult resolve(URIPattern pattern, VariableBinder binder) {
        URIResolveResult result = new URIResolveResult(pattern);
        Matcher mx = pattern.pattern().matcher(this._uri);
        boolean match = mx.matches();
        if (!match || mx.groupCount() != pattern.tokens().size()) {
            result.setStatus(URIResolveResult.Status.ERROR);
            return result;
        }
        List<Token> tokens = pattern.tokens();
        HashMap<Variable, Object> map = new HashMap<Variable, Object>();
        for (int i = 0; i < mx.groupCount(); ++i) {
            Token mt = tokens.get(i);
            String s = mx.group(i + 1);
            mt.resolve(s, map);
        }
        this.lookup(result, map, binder);
        return result;
    }

    private void lookup(URIResolveResult result, Map<Variable, Object> map, VariableBinder binder) {
        URIResolveResult.Status status = URIResolveResult.Status.RESOLVED;
        for (Map.Entry<Variable, Object> entry : map.entrySet()) {
            Variable var = entry.getKey();
            VariableResolver r = binder.getResolver(var.name(), var.type());
            Object value = entry.getValue();
            if (value instanceof String) {
                Object o = r.resolve(value.toString());
                result.put(entry.getKey().name(), o);
                if (o != null) continue;
                status = URIResolveResult.Status.UNRESOLVED;
                continue;
            }
            if (value instanceof String[]) {
                status = URIResolveResult.Status.ERROR;
                continue;
            }
            status = URIResolveResult.Status.ERROR;
        }
        result.setStatus(status);
    }

    private URIPattern findFirst(Set<URIPattern> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return null;
        }
        for (URIPattern p : patterns) {
            if (!p.match(this._uri)) continue;
            return p;
        }
        return null;
    }

    private URIPattern findBest(Set<URIPattern> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return null;
        }
        URIPattern best = null;
        for (URIPattern p : patterns) {
            if (!p.match(this._uri) || best != null && p.score() <= best.score()) continue;
            best = p;
        }
        return best;
    }

    public static enum MatchRule {
        FIRST_MATCH,
        BEST_MATCH;

    }
}

