/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestXmlSchemaValidator
implements IRestSchemaValidatorStrategy {
    public static final String RAML_EXTERNAL_ENTITIES_PROPERTY = "raml.xml.expandExternalEntities";
    public static final String RAML_EXPAND_ENTITIES_PROPERTY = "raml.xml.expandInternalEntities";
    public static final String MULE_EXTERNAL_ENTITIES_PROPERTY = "mule.xml.expandExternalEntities";
    public static final String MULE_EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities";
    protected static final Logger logger = LoggerFactory.getLogger(RestXmlSchemaValidator.class);
    private Schema schema;

    public RestXmlSchemaValidator(Schema schemaCache) {
        this.schema = schemaCache;
    }

    @Override
    public void validate(String payload) throws BadRequestException {
        if (System.getProperty(MULE_EXTERNAL_ENTITIES_PROPERTY) == null) {
            System.setProperty(MULE_EXTERNAL_ENTITIES_PROPERTY, System.getProperty(RAML_EXTERNAL_ENTITIES_PROPERTY, "false"));
        }
        if (System.getProperty(MULE_EXPAND_ENTITIES_PROPERTY) == null) {
            System.setProperty(MULE_EXPAND_ENTITIES_PROPERTY, System.getProperty(RAML_EXPAND_ENTITIES_PROPERTY, "false"));
        }
        try {
            Document data = RestXmlSchemaValidator.loadDocument(new StringReader(payload));
            Validator validator = this.schema.newValidator();
            validator.validate(new DOMSource(data.getDocumentElement()));
        }
        catch (IOException | SAXException e) {
            logger.info("Schema validation failed: " + e.getMessage());
            throw ApikitErrorTypes.throwErrorType(new BadRequestException(e));
        }
    }

    private static Document loadDocument(Reader reader) throws IOException {
        return RestXmlSchemaValidator.loadDocument(new InputSource(reader));
    }

    private static Document loadDocument(InputSource source) throws IOException {
        DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("An internal operation failed.", e);
        }
        catch (SAXException e) {
            throw new IOException("An internal operation failed.", e);
        }
    }
}

