/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mule.module.apikit.api.exception.InvalidQueryParameterException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.util.MultiMap;

public class QueryParameterValidator {
    private MultiMap<String, String> queryParams;
    private String queryString;
    private IAction action;

    public QueryParameterValidator(IAction action) {
        this.action = action;
    }

    public void validateAndAddDefaults(MultiMap<String, String> queryParams, String queryString, boolean queryParamsStrictValidation) throws InvalidQueryParameterException {
        if (queryParamsStrictValidation) {
            this.validateQueryParametersStrictly(queryParams);
        }
        for (String expectedKey : this.action.getQueryParameters().keySet()) {
            IParameter expected = (IParameter)this.action.getQueryParameters().get(expectedKey);
            List actual = queryParams.getAll((Object)expectedKey);
            if (actual.isEmpty()) {
                if (expected.isRequired()) {
                    throw new InvalidQueryParameterException("Required query parameter " + expectedKey + " not specified");
                }
                if (expected.getDefaultValue() == null) continue;
                queryString = AttributesHelper.addQueryString(queryString, queryParams.size(), expectedKey, expected.getDefaultValue());
                queryParams = AttributesHelper.addParam(queryParams, expectedKey, expected.getDefaultValue());
                continue;
            }
            if (actual.size() > 1 && !expected.isRepeat() && !expected.isArray()) {
                throw new InvalidQueryParameterException("Query parameter " + expectedKey + " is not repeatable");
            }
            if (expected.isArray()) {
                this.validateQueryParamArray(expectedKey, expected, actual);
                continue;
            }
            for (String param : actual) {
                this.validateQueryParam(expectedKey, expected, param);
            }
        }
        this.queryParams = queryParams;
        this.queryString = queryString;
    }

    private void validateQueryParametersStrictly(MultiMap<String, String> queryParams) throws InvalidQueryParameterException {
        Sets.SetView notDefinedQueryParameters = Sets.difference((Set)queryParams.keySet(), this.action.getQueryParameters().keySet());
        if (!notDefinedQueryParameters.isEmpty()) {
            throw new InvalidQueryParameterException(Joiner.on((String)", ").join((Iterable)notDefinedQueryParameters) + " parameters are not defined in RAML.");
        }
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryString() {
        return this.queryString;
    }

    private void validateQueryParamArray(String paramKey, IParameter expected, Collection<?> paramValues) throws InvalidQueryParameterException {
        StringBuilder builder = new StringBuilder();
        paramValues.forEach(paramValue -> {
            String value = String.valueOf(paramValue);
            builder.append("- ");
            if (value.startsWith("*")) {
                builder.append("\"").append(value).append("\"");
            } else {
                builder.append(value);
            }
            builder.append("\n");
        });
        this.validateQueryParam(paramKey, expected, builder.toString());
    }

    private void validateQueryParam(String paramKey, IParameter expected, String paramValue) throws InvalidQueryParameterException {
        if (!expected.validate(paramValue)) {
            String msg = String.format("Invalid value '%s' for query parameter %s. %s", paramValue, paramKey, expected.message(paramValue));
            throw new InvalidQueryParameterException(msg);
        }
    }
}

