/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.CharsetUtils;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PayloadHelper.class);

    public static String getPayloadAsString(Object input, String charset) throws BadRequestException {
        try {
            byte[] bytes;
            if (input instanceof CursorStreamProvider) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)((CursorStreamProvider)input).openCursor()));
            } else if (input instanceof RewindableInputStream) {
                RewindableInputStream rewindable = (RewindableInputStream)input;
                bytes = IOUtils.toByteArray((InputStream)rewindable);
                rewindable.rewind();
            } else if (input instanceof InputStream) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)input));
            } else if (input instanceof String) {
                bytes = ((String)input).getBytes();
            } else if (input instanceof byte[]) {
                bytes = (byte[])input;
            } else {
                if (input != null) {
                    throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
                }
                throw new BadRequestException("Don't know how to parse payload");
            }
            return IOUtils.toString((byte[])CharsetUtils.trimBom(bytes), (String)charset);
        }
        catch (IOException e) {
            throw new BadRequestException("Error processing request: " + e.getMessage());
        }
    }
}

