/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.HeaderName;
import org.mule.runtime.api.util.MultiMap;

public class AttributesHelper {
    private static final String ANY_RESPONSE_MEDIA_TYPE = "*/*";

    private AttributesHelper() {
    }

    public static MultiMap<String, String> addParam(MultiMap<String, String> oldParams, String key, String value) {
        MultiMap mapParam = new MultiMap();
        LinkedList<String> valueList = new LinkedList<String>();
        valueList.add(value);
        mapParam.put((Object)key, valueList);
        for (Map.Entry entry : oldParams.entrySet()) {
            LinkedList list = new LinkedList();
            list.add(entry.getValue());
            mapParam.put(entry.getKey(), list);
        }
        return mapParam;
    }

    public static String addQueryString(String oldQueryString, int queryStringSize, String key, String value) {
        String newParam = queryStringSize != 0 ? "&" : "";
        try {
            newParam = newParam + URLEncoder.encode(key, "UTF-8");
            if (value != null) {
                newParam = newParam + "=" + URLEncoder.encode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return oldQueryString + newParam;
    }

    public static HttpRequestAttributes replaceParams(HttpRequestAttributes attributes, MultiMap<String, String> headers, MultiMap<String, String> queryParams, String queryString, MultiMap<String, String> uriParams) {
        return new HttpRequestAttributes(headers, attributes.getListenerPath(), attributes.getRelativePath(), attributes.getVersion(), attributes.getScheme(), attributes.getMethod(), attributes.getRequestPath(), attributes.getRequestUri(), queryString, queryParams, uriParams, attributes.getRemoteAddress(), attributes.getClientCertificate());
    }

    public static String getHeaderIgnoreCase(HttpRequestAttributes attributes, HeaderName name) {
        return AttributesHelper.getHeaderIgnoreCase(attributes, name.getName());
    }

    public static String getHeaderIgnoreCase(HttpRequestAttributes attributes, String name) {
        MultiMap headers = attributes.getHeaders();
        return AttributesHelper.getParamIgnoreCase((MultiMap<String, String>)headers, name);
    }

    public static String getParamIgnoreCase(MultiMap<String, String> parameters, String name) {
        for (String header : parameters.keySet()) {
            if (!header.equalsIgnoreCase(name.toLowerCase())) continue;
            return (String)parameters.get((Object)header);
        }
        return null;
    }

    public static List<String> getParamsIgnoreCase(MultiMap<String, String> parameters, String name) {
        return parameters.keySet().stream().filter(header -> header.equalsIgnoreCase(name)).findFirst().map(arg_0 -> parameters.getAll(arg_0)).orElse(Collections.emptyList());
    }

    public static String getMediaType(HttpRequestAttributes attributes) {
        String contentType = AttributesHelper.getHeaderIgnoreCase(attributes, HeaderName.CONTENT_TYPE);
        return contentType != null ? contentType.split(";")[0] : null;
    }

    public static String getAcceptedResponseMediaTypes(MultiMap<String, String> headers) {
        String acceptableResponseMediaTypes = AttributesHelper.getParamIgnoreCase(headers, "accept");
        if (Strings.isNullOrEmpty((String)acceptableResponseMediaTypes)) {
            return ANY_RESPONSE_MEDIA_TYPE;
        }
        return acceptableResponseMediaTypes;
    }
}

