/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;

public class RoutingTable {
    protected Map<URIPattern, IResource> routingTable = new HashMap<URIPattern, IResource>();

    public RoutingTable(IRaml api) {
        this.buildRoutingTable(api.getResources(), api.getVersion());
    }

    private void buildRoutingTable(Map<String, IResource> resources, String version) {
        for (IResource resource : resources.values()) {
            String parentUri = resource.getParentUri();
            String uri = resource.getResolvedUri(version);
            this.routingTable.put(new URIPattern(uri), resource);
            if (resource.getResources() == null) continue;
            this.buildRoutingTable(resource.getResources(), version);
        }
    }

    public IResource getResource(String uri) {
        return this.routingTable.get(new URIPattern(uri));
    }

    public IResource getResource(URIPattern uriPattern) {
        return this.routingTable.get(uriPattern);
    }

    public Set<URIPattern> keySet() {
        return this.routingTable.keySet();
    }
}

