/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.HashMap;
import java.util.Map;
import org.mule.module.apikit.Configuration;

public class ApikitRegistry {
    private Map<String, Configuration> configMap;
    private Map<String, String> apiSourceMap;

    public void registerConfiguration(Configuration config) {
        if (this.configMap == null) {
            this.configMap = new HashMap<String, Configuration>();
        }
        this.configMap.put(config.getName(), config);
        if (this.apiSourceMap != null) {
            config.getRamlHandler().setApiServer(this.apiSourceMap.get(config.getName()));
            for (String apiSourceMapItem : this.apiSourceMap.keySet()) {
                if (this.configMap.get(apiSourceMapItem) == null) continue;
                this.configMap.get(apiSourceMapItem).getRamlHandler().setApiServer(this.apiSourceMap.get(apiSourceMapItem));
            }
        }
    }

    public Configuration getConfiguration(String configName) {
        return this.configMap.get(configName);
    }

    public void setApiSource(String configName, String apiSource) {
        if (this.apiSourceMap == null) {
            this.apiSourceMap = new HashMap<String, String>();
        }
        this.apiSourceMap.put(configName, apiSource);
        if (this.configMap != null) {
            for (String apiSourceMapItem : this.apiSourceMap.keySet()) {
                if (this.configMap.get(apiSourceMapItem) == null) continue;
                this.configMap.get(apiSourceMapItem).getRamlHandler().setApiServer(this.apiSourceMap.get(apiSourceMapItem));
            }
        }
    }
}

