/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.util.List;
import java.util.Map;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidatorStrategy;
import org.mule.module.apikit.validation.body.form.transformation.DataWeaveDefaultsBuilder;
import org.mule.module.apikit.validation.body.form.transformation.DataWeaveTransformer;
import org.mule.module.apikit.validation.body.form.transformation.TextPlainPart;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartFormValidator
implements FormValidatorStrategy<TypedValue> {
    protected final Logger logger = LoggerFactory.getLogger(MultipartFormValidator.class);
    Map<String, List<IParameter>> formParameters;
    DataWeaveTransformer dataWeaveTransformer;

    public MultipartFormValidator(Map<String, List<IParameter>> formParameters, ExpressionManager expressionManager) {
        this.formParameters = formParameters;
        this.dataWeaveTransformer = new DataWeaveTransformer(expressionManager);
    }

    @Override
    public TypedValue validate(TypedValue originalPayload) throws InvalidFormParameterException {
        MultiMap<String, String> actualParameters = this.dataWeaveTransformer.getMultiMapFromPayload(originalPayload);
        DataWeaveDefaultsBuilder defaultsBuilder = new DataWeaveDefaultsBuilder();
        for (String expectedKey : this.formParameters.keySet()) {
            if (this.formParameters.get(expectedKey).size() != 1) continue;
            IParameter expected = this.formParameters.get(expectedKey).get(0);
            if (actualParameters.keySet().contains(expectedKey)) {
                String value = (String)actualParameters.get(expectedKey);
                if (expected.validate(value)) continue;
                throw new InvalidFormParameterException("Value " + value + " for parameter " + expectedKey + " is invalid");
            }
            if (expected.getDefaultValue() != null) {
                defaultsBuilder.addPart(new TextPlainPart().setName(expectedKey).setValue(expected.getDefaultValue()));
                continue;
            }
            if (!expected.isRequired()) continue;
            throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
        }
        if (defaultsBuilder.areDefaultsToAdd()) {
            return this.dataWeaveTransformer.runDataWeaveScript(defaultsBuilder.build(), originalPayload.getDataType(), originalPayload);
        }
        return originalPayload;
    }
}

