/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.privileged.executor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mule.extension.aggregator.internal.errors.AggregatorError;
import org.mule.extension.aggregator.internal.parameter.SizeBasedAggregatorParameterGroup;
import org.mule.extension.aggregator.internal.privileged.CompletionCallbackWrapper;
import org.mule.extension.aggregator.internal.privileged.executor.SingleGroupAggregatorExecutor;
import org.mule.extension.aggregator.internal.routes.AggregationCompleteRoute;
import org.mule.extension.aggregator.internal.routes.IncrementalAggregationRoute;
import org.mule.extension.aggregator.internal.storage.content.AggregatedContent;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.reactivestreams.Publisher;

public class SizeBasedAggregatorOperationsExecutor
extends SingleGroupAggregatorExecutor {
    private static final String AGGREGATOR_KEY = "SizeBasedAggregator";
    private int maxSize;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public SizeBasedAggregatorOperationsExecutor(Map<String, Object> params) {
        this.injectParameters(params);
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        CoreEvent event = context.getEvent();
        IncrementalAggregationRoute incrementalAggregationRoute = (IncrementalAggregationRoute)((Object)context.getParameter("incrementalAggregation"));
        AggregationCompleteRoute aggregationCompleteRoute = (AggregationCompleteRoute)((Object)context.getParameter("aggregationComplete"));
        SizeBasedAggregatorParameterGroup parameters = this.createParameters(context.getParameters());
        Optional<ItemSequenceInfo> itemSequenceInfo = this.getItemSequenceInfo(executionContext);
        this.aggregate(parameters, incrementalAggregationRoute, aggregationCompleteRoute, new CompletionCallbackWrapper((CompletionCallback)context.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), event), itemSequenceInfo);
        return null;
    }

    private SizeBasedAggregatorParameterGroup createParameters(Map<String, Object> parameterMap) {
        SizeBasedAggregatorParameterGroup parameters = new SizeBasedAggregatorParameterGroup();
        parameters.setContent((TypedValue)parameterMap.get("content"));
        parameters.setTimeout((Integer)parameterMap.get("timeout"));
        parameters.setTimeoutUnit((TimeUnit)((Object)parameterMap.get("timeoutUnit")));
        return parameters;
    }

    @Override
    protected void injectParameters(Map<String, Object> parameters) {
        super.injectParameters(parameters);
        this.maxSize = (Integer)parameters.get("maxSize");
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.setGroupSize(this.maxSize);
    }

    @Override
    String doGetAggregatorKey() {
        return AGGREGATOR_KEY;
    }

    private void aggregate(SizeBasedAggregatorParameterGroup aggregatorParameters, IncrementalAggregationRoute incrementalAggregationRoute, AggregationCompleteRoute onAggregationCompleteRoute, CompletionCallbackWrapper completionCallback, Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.evaluateParameters(aggregatorParameters);
        CompletableFuture<Result<Object, Object>> future = new CompletableFuture<Result<Object, Object>>();
        this.executeSynchronized(() -> {
            AggregatedContent aggregatedContent = this.getAggregatedContent();
            if (aggregatorParameters.isTimeoutSet()) {
                this.registerAsyncAggregationIfNeeded(aggregatorParameters.getTimeout(), aggregatorParameters.getTimeoutUnit());
            }
            this.addToStorage(aggregatedContent, aggregatorParameters.getContent(), itemSequenceInfo);
            if (aggregatedContent.isComplete()) {
                this.notifyListenerOnComplete(aggregatedContent.getAggregatedElements(), this.getAttributes(aggregatedContent));
                this.executeRouteWithAggregatedElements(onAggregationCompleteRoute, aggregatedContent.getAggregatedElements(), this.getAttributes(aggregatedContent), future);
                this.onCompleteAggregation();
            } else if (incrementalAggregationRoute != null) {
                this.executeRouteWithAggregatedElements(incrementalAggregationRoute, aggregatedContent.getAggregatedElements(), this.getAttributes(aggregatedContent), future);
            } else {
                future.complete(Result.builder().build());
            }
            return true;
        });
        this.finishExecution(future, completionCallback);
    }

    private void evaluateParameters(SizeBasedAggregatorParameterGroup aggregatorParameters) {
        if (aggregatorParameters.isTimeoutSet()) {
            if (aggregatorParameters.getTimeout() <= 0) {
                throw new ModuleException(String.format("A configured timeout of %d is not valid. Value should be bigger than 0", aggregatorParameters.getTimeout()), (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
            }
            this.evaluateConfiguredDelay("timeout", aggregatorParameters.getTimeout(), aggregatorParameters.getTimeoutUnit());
        }
        if (this.maxSize <= 0) {
            throw new ModuleException(String.format("maxSize should be bigger than 0, got: %d", this.maxSize), (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
        }
    }

    @Override
    void onAsyncAggregationExecution() {
        this.onTimeout();
    }

    private void onTimeout() {
        this.notifyListenerOnTimeout(this.getAggregatedContent().getAggregatedElements(), this.getAttributes(this.getAggregatedContent()));
        this.resetGroup();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Aggregation timed out");
        }
    }
}

