/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.privileged.executor;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mule.extension.aggregator.api.AggregationAttributes;
import org.mule.extension.aggregator.internal.errors.AggregatorError;
import org.mule.extension.aggregator.internal.parameter.GroupBasedAggregatorParameterGroup;
import org.mule.extension.aggregator.internal.privileged.CompletionCallbackWrapper;
import org.mule.extension.aggregator.internal.privileged.executor.AbstractAggregatorExecutor;
import org.mule.extension.aggregator.internal.routes.AggregationCompleteRoute;
import org.mule.extension.aggregator.internal.routes.IncrementalAggregationRoute;
import org.mule.extension.aggregator.internal.storage.content.AbstractAggregatedContent;
import org.mule.extension.aggregator.internal.storage.content.AggregatedContent;
import org.mule.extension.aggregator.internal.storage.content.SimpleAggregatedContent;
import org.mule.extension.aggregator.internal.storage.info.AggregatorSharedInformation;
import org.mule.extension.aggregator.internal.storage.info.GroupAggregatorSharedInformation;
import org.mule.extension.aggregator.internal.task.AsyncTask;
import org.mule.extension.aggregator.internal.task.SimpleAsyncTask;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.reactivestreams.Publisher;

public class GroupBasedAggregatorOperationsExecutor
extends AbstractAggregatorExecutor {
    private static final String AGGREGATOR_KEY = "GroupBasedAggregator";
    private int lastConfiguredEvictionTime;
    private TimeUnit lastConfiguredEvictionTimeUnit;

    public GroupBasedAggregatorOperationsExecutor(Map<String, Object> params) {
        this.injectParameters(params);
    }

    public int getLastConfiguredEvictionTime() {
        return this.lastConfiguredEvictionTime;
    }

    public void setLastConfiguredEvictionTime(int lastConfiguredEvictionTime) {
        this.lastConfiguredEvictionTime = lastConfiguredEvictionTime;
    }

    public TimeUnit getLastConfiguredEvictionTimeUnit() {
        return this.lastConfiguredEvictionTimeUnit;
    }

    public void setLastConfiguredEvictionTimeUnit(TimeUnit lastConfiguredEvictionTimeUnit) {
        this.lastConfiguredEvictionTimeUnit = lastConfiguredEvictionTimeUnit;
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        CoreEvent event = context.getEvent();
        IncrementalAggregationRoute incrementalAggregationRoute = (IncrementalAggregationRoute)((Object)context.getParameter("incrementalAggregation"));
        AggregationCompleteRoute aggregationCompleteRoute = (AggregationCompleteRoute)((Object)context.getParameter("aggregationComplete"));
        GroupBasedAggregatorParameterGroup parameters = this.createParameters(context.getParameters());
        Optional<ItemSequenceInfo> itemSequenceInfo = this.getItemSequenceInfo(executionContext);
        this.aggregate(parameters, incrementalAggregationRoute, aggregationCompleteRoute, new CompletionCallbackWrapper((CompletionCallback)context.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), event), itemSequenceInfo);
        return null;
    }

    private GroupBasedAggregatorParameterGroup createParameters(Map<String, Object> parameterMap) {
        GroupBasedAggregatorParameterGroup parameters = new GroupBasedAggregatorParameterGroup();
        parameters.setEvictionTime((Integer)parameterMap.get("evictionTime"));
        parameters.setEvictionTimeUnit((TimeUnit)((Object)parameterMap.get("evictionTimeUnit")));
        parameters.setGroupId((String)parameterMap.get("groupId"));
        parameters.setContent((TypedValue)parameterMap.get("content"));
        parameters.setGroupSize((Integer)parameterMap.get("groupSize"));
        parameters.setTimeout((Integer)parameterMap.get("timeout"));
        parameters.setTimeoutUnit((TimeUnit)((Object)parameterMap.get("timeoutUnit")));
        return parameters;
    }

    @Override
    String doGetAggregatorKey() {
        return AGGREGATOR_KEY;
    }

    private void aggregate(GroupBasedAggregatorParameterGroup aggregatorParameters, IncrementalAggregationRoute incrementalAggregationRoute, AggregationCompleteRoute onAggregationCompleteRoute, CompletionCallbackWrapper completionCallback, Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.evaluateParameters(aggregatorParameters);
        this.lastConfiguredEvictionTime = aggregatorParameters.getEvictionTime();
        this.lastConfiguredEvictionTimeUnit = aggregatorParameters.getEvictionTimeUnit();
        CompletableFuture<Result<Object, Object>> future = new CompletableFuture<Result<Object, Object>>();
        this.executeSynchronized(() -> {
            AggregatedContent groupAggregatedContent;
            if (aggregatorParameters.isTimeoutSet()) {
                this.registerTimeoutIfNeeded(aggregatorParameters.getGroupId(), aggregatorParameters.getTimeout(), aggregatorParameters.getTimeoutUnit());
            }
            if ((groupAggregatedContent = this.getOrCreateAggregatedContent(aggregatorParameters.getGroupId(), aggregatorParameters.getGroupSize())).isComplete()) {
                throw new ModuleException(String.format("Trying to aggregate a new element to the group with id: %s ,but it's already complete", aggregatorParameters.getGroupId()), (ErrorTypeDefinition)AggregatorError.GROUP_COMPLETED);
            }
            if (((SimpleAggregatedContent)groupAggregatedContent).isTimedOut()) {
                throw new ModuleException(String.format("Trying to aggregate a new element to the group with id: %s ,but it has already timed out", aggregatorParameters.getGroupId()), (ErrorTypeDefinition)AggregatorError.GROUP_TIMED_OUT);
            }
            this.addToStorage(groupAggregatedContent, aggregatorParameters.getContent(), itemSequenceInfo);
            if (groupAggregatedContent.isComplete()) {
                List<TypedValue> aggregatedElements = groupAggregatedContent.getAggregatedElements();
                this.notifyListenerOnComplete(aggregatedElements, this.getAttributes(aggregatorParameters.getGroupId(), groupAggregatedContent));
                this.handleGroupEviction(aggregatorParameters.getGroupId(), aggregatorParameters.getEvictionTime(), aggregatorParameters.getEvictionTimeUnit());
                this.executeRouteWithAggregatedElements(onAggregationCompleteRoute, aggregatedElements, this.getAttributes(aggregatorParameters.getGroupId(), groupAggregatedContent), future);
                this.getSharedInfoLocalCopy().getRegisteredTimeoutAsyncAggregations().remove(aggregatorParameters.getGroupId());
            } else if (incrementalAggregationRoute != null) {
                this.executeRouteWithAggregatedElements(incrementalAggregationRoute, groupAggregatedContent.getAggregatedElements(), this.getAttributes(aggregatorParameters.getGroupId(), groupAggregatedContent), future);
            } else {
                future.complete(Result.builder().build());
            }
            return true;
        });
        this.finishExecution(future, completionCallback);
    }

    private void evaluateParameters(GroupBasedAggregatorParameterGroup parameterGroup) throws ModuleException {
        if (parameterGroup.getGroupId() == null) {
            throw new ModuleException("groupId expression resolves to null", (ErrorTypeDefinition)AggregatorError.NO_GROUP_ID);
        }
        if (parameterGroup.getGroupSize() == null) {
            throw new ModuleException("groupSize expression resolves to null", (ErrorTypeDefinition)AggregatorError.NO_GROUP_SIZE);
        }
        if (parameterGroup.getGroupSize() <= 0) {
            throw new ModuleException(String.format("groupSize should be bigger than 0, got: %d", parameterGroup.getGroupSize()), (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
        }
        if (parameterGroup.getEvictionTime() > 0) {
            this.evaluateConfiguredDelay("evictionTime", parameterGroup.getEvictionTime(), parameterGroup.getEvictionTimeUnit());
        }
        if (parameterGroup.isTimeoutSet()) {
            if (parameterGroup.getTimeout() <= 0) {
                throw new ModuleException(String.format("A configured timeout of %d is not valid. Value should be bigger than 0", parameterGroup.getTimeout()), (ErrorTypeDefinition)AggregatorError.AGGREGATOR_CONFIG);
            }
            this.evaluateConfiguredDelay("timeout", parameterGroup.getTimeout(), parameterGroup.getTimeoutUnit());
        }
    }

    private void handleGroupEviction(String groupId, int evictionTime, TimeUnit evictionUnit) {
        if (evictionTime == 0) {
            this.evictGroup(groupId);
        } else if (evictionTime > 0) {
            this.registerGroupEvictionIfNeeded(groupId, evictionTime, evictionUnit);
        }
    }

    private void evictGroup(String groupId) {
        this.getSharedInfoLocalCopy().removeAggregatedContent(groupId);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Group with id: %s evicted", groupId));
        }
    }

    private void onGroupEviction(String groupId) {
        this.evictGroup(groupId);
    }

    private void onTimeout(String groupId) {
        AggregatedContent groupStorage = this.getSharedInfoLocalCopy().getAggregatedContent(groupId);
        if (groupStorage != null) {
            List<TypedValue> elements = groupStorage.getAggregatedElements();
            ((SimpleAggregatedContent)groupStorage).setTimedOut();
            this.notifyListenerOnTimeout(elements, this.getAttributes(groupId, groupStorage));
            this.handleGroupEviction(groupId, this.lastConfiguredEvictionTime, this.lastConfiguredEvictionTimeUnit);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Group with id: %s timed out", groupId));
            }
        }
    }

    private AggregatedContent getOrCreateAggregatedContent(String groupId, int groupSize) {
        AggregatedContent aggregatedContent = this.getSharedInfoLocalCopy().getAggregatedContent(groupId);
        if (aggregatedContent == null) {
            aggregatedContent = new SimpleAggregatedContent(groupSize);
            this.getSharedInfoLocalCopy().setAggregatedContent(groupId, aggregatedContent);
        }
        if (((AbstractAggregatedContent)aggregatedContent).getMaxSize() != groupSize) {
            this.LOGGER.warn(String.format("Group size for groupId: %s is different from the first configured one. Was: %d, is: %d, using: %d", groupId, ((AbstractAggregatedContent)aggregatedContent).getMaxSize(), groupSize, ((AbstractAggregatedContent)aggregatedContent).getMaxSize()));
        }
        return aggregatedContent;
    }

    private AggregationAttributes getAttributes(String groupId, AggregatedContent aggregatedContent) {
        return new AggregationAttributes(groupId, aggregatedContent.getFirstValueArrivalTime(), aggregatedContent.getLastValueArrivalTime(), aggregatedContent.isComplete());
    }

    @Override
    GroupAggregatorSharedInformation getSharedInfoLocalCopy() throws ModuleException {
        return (GroupAggregatorSharedInformation)super.getSharedInfoLocalCopy();
    }

    @Override
    AggregatorSharedInformation createSharedInfo() {
        return new GroupAggregatorSharedInformation();
    }

    private void registerTimeoutIfNeeded(String groupId, int delay, TimeUnit unit) {
        if (this.getSharedInfoLocalCopy().shouldRegisterTimeout(groupId)) {
            SimpleAsyncTask task = new SimpleAsyncTask(delay, unit);
            task.setRegistered(this.getCurrentTime());
            this.getSharedInfoLocalCopy().registerTimeoutAsyncAggregation(groupId, task);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Registered timeout to be executed for groupId: %s in %d %s", new Object[]{groupId, delay, unit}));
            }
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Attempted to register timeout task for groupId: %s but it was already registered", groupId));
        }
    }

    private void registerGroupEvictionIfNeeded(String groupId, int delay, TimeUnit unit) {
        if (this.getSharedInfoLocalCopy().shouldRegisterEviction(groupId)) {
            SimpleAsyncTask task = new SimpleAsyncTask(delay, unit);
            task.setRegistered(this.getCurrentTime());
            this.getSharedInfoLocalCopy().registerGroupEvictionTask(groupId, task);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Registered group eviction to be executed for groupId: %s in %d %s", new Object[]{groupId, delay, unit}));
            }
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Attempted to register group eviction for groupId: %s but it was already registered", groupId));
        }
    }

    @Override
    boolean doScheduleRegisteredAsyncAggregations() {
        this.getSharedInfoLocalCopy().getRegisteredGroupEvictionTasks().forEach(this::scheduleGroupEvictionIfNeeded);
        this.getSharedInfoLocalCopy().getRegisteredTimeoutAsyncAggregations().forEach(this::scheduleTimeoutIfNeeded);
        return true;
    }

    @Override
    boolean doSetRegisteredAsyncAggregationsAsNotScheduled() {
        this.getSharedInfoLocalCopy().getRegisteredGroupEvictionTasks().forEach((key, value) -> value.setUnscheduled());
        this.getSharedInfoLocalCopy().getRegisteredTimeoutAsyncAggregations().forEach((key, value) -> value.setUnscheduled());
        return true;
    }

    private void scheduleGroupEvictionIfNeeded(String groupId, AsyncTask task) {
        if (!task.isScheduled()) {
            this.scheduleTask(task, () -> this.executeSynchronized(() -> {
                this.onGroupEviction(groupId);
                this.getSharedInfoLocalCopy().unregisterGroupEvictionTask(groupId);
                return true;
            }));
            task.setScheduled();
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Scheduled group eviction for groupId: %s to be executed in %d %s", new Object[]{groupId, task.getDelay(), task.getDelayTimeUnit()}));
            }
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Attempted to schedule a group eviction for groupId: %s, but it is already scheduled", groupId));
        }
    }

    private void scheduleTimeoutIfNeeded(String groupId, AsyncTask task) {
        if (!task.isScheduled()) {
            this.scheduleTask(task, () -> this.executeSynchronized(() -> {
                if (this.getSharedInfoLocalCopy().getRegisteredTimeoutAsyncAggregations().get(groupId) != null && task.getId().equals(this.getSharedInfoLocalCopy().getRegisteredTimeoutAsyncAggregations().get(groupId).getId())) {
                    this.onTimeout(groupId);
                    this.getSharedInfoLocalCopy().unregisterTimeoutAsyncAggregation(groupId);
                }
                return true;
            }));
            task.setScheduled();
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug(String.format("Scheduled timeout for groupId: %s to be executed in %d %s", new Object[]{groupId, task.getDelay(), task.getDelayTimeUnit()}));
            }
        } else if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Attempted to schedule timeout for groupId: %s, but it is already scheduled", groupId));
        }
    }
}

