/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.function;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.JavaModuleUtils;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class JavaModuleFunctions {
    @Inject
    private JavaModuleLoadingCache cache;

    public Object invoke(@Alias(value="class") @Summary(value="Fully qualified name of the Class containing the referenced Method") String clazz, @Alias(value="method") @Summary(value="Represents the Method signature containing the method name and it's argument types.") String methodName, Object instance, @Optional Map<String, Object> args) throws NoSuchMethodModuleException, ClassNotFoundModuleException, WrongTypeModuleException, ArgumentMismatchModuleException, InvocationModuleException {
        Map<String, TypedValue<Object>> resolvedArgs = args == null ? Collections.emptyMap() : args.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> TypedValue.of(e.getValue())));
        JavaModuleUtils.validateType(clazz, instance, true, this.cache);
        MethodIdentifier identifier = new MethodIdentifier(clazz, methodName);
        Method method = this.cache.getMethod(identifier, instance.getClass(), resolvedArgs, false);
        return JavaModuleUtils.invokeMethod(method, resolvedArgs, instance, () -> String.format("Failed to invoke Method [%s] in Class [%s]", methodName, clazz));
    }

    public boolean isInstanceOf(Object instance, @Alias(value="class") String clazz) throws ClassNotFoundModuleException {
        return ClassUtils.isInstance(this.cache.loadClass(clazz), (Object)instance);
    }
}

