/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.extension.introspection.Capable;

public abstract class CapableDeclaration<T extends CapableDeclaration>
implements Capable {
    private Set<Object> capabilities = new HashSet<Object>();

    public Set<Object> getCapabilities() {
        return Collections.unmodifiableSet(this.capabilities);
    }

    public <C> Set<C> getCapabilities(Class<C> capabilityType) {
        LinkedHashSet<Object> matchingCapabilities = new LinkedHashSet<Object>(this.capabilities.size());
        for (Object capability : this.capabilities) {
            if (!capabilityType.isAssignableFrom(capability.getClass())) continue;
            matchingCapabilities.add(capability);
        }
        return Collections.unmodifiableSet(matchingCapabilities);
    }

    public T addCapability(Object capability) {
        if (capability == null) {
            throw new IllegalArgumentException("Can't add a null capability");
        }
        this.capabilities.add(capability);
        return (T)this;
    }

    @Override
    public boolean isCapableOf(Class<?> capabilityType) {
        for (Object capability : this.capabilities) {
            if (!capabilityType.isInstance(capability)) continue;
            return true;
        }
        return false;
    }
}

