/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.scripting;

import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.NumberUtils;

public class AccumulatorComponent
implements Callable {
    private String operation = "add";
    private double accumulatedValue = 0.0;

    public Object onCall(MuleEventContext context) throws Exception {
        Object msg = context.getMessage().getPayload();
        double data = NumberUtils.toDouble((Object)msg);
        if (data == -9.99999999E8) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)("Unable to convert message to double: " + msg)));
        }
        if (this.operation.equalsIgnoreCase("add")) {
            this.accumulatedValue += data;
        } else if (this.operation.equalsIgnoreCase("subtract")) {
            this.accumulatedValue -= data;
        } else if (this.operation.equalsIgnoreCase("multiply")) {
            this.accumulatedValue *= data;
        } else if (this.operation.equalsIgnoreCase("divide")) {
            this.accumulatedValue /= data;
        } else {
            throw new TransformerException(MessageFactory.createStaticMessage((String)("Operation " + this.operation + " not recognized")));
        }
        return new Double(this.accumulatedValue);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

