/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.esb;

import org.apache.activemq.broker.BrokerService;
import org.mule.MuleManager;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.examples.loanbroker.AbstractMain;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOMessage;

public class Main
extends AbstractMain {
    private MuleClient client = null;
    private BrokerService msgBroker = new BrokerService();

    public Main(String config) throws Exception {
        this.msgBroker.addConnector("tcp://localhost:61616");
        this.msgBroker.start();
        MuleXmlConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
        builder.configure(config, null);
        this.client = new MuleClient();
    }

    public void close() throws Exception {
        MuleManager.getInstance().dispose();
        if (this.msgBroker != null) {
            this.msgBroker.stop();
        }
    }

    public UMOMessage request(CustomerQuoteRequest request) throws Exception {
        return this.client.send("vm://customer.requests", (Object)request, null);
    }

    public static void main(String[] args) {
        Main loanConsumer = null;
        int response = 0;
        try {
            System.out.println("******************\n" + new Message("loanbroker-example", 30).getMessage() + "\n******************");
            response = Main.readCharacter();
            if (response == 49) {
                System.out.println(new Message("loanbroker-example", 31).getMessage());
                loanConsumer = new Main("loan-broker-esb-mule-config.xml");
            } else if (response == 113) {
                System.out.println(new Message("loanbroker-example", 32).getMessage());
                System.exit(0);
            } else {
                System.out.println(new Message("loanbroker-example", 33).getMessage());
                loanConsumer = new Main("loan-broker-esb-mule-config-with-ejb-container.xml");
            }
            while (response != 113) {
                System.out.println("\n" + new Message("loanbroker-example", 34).getMessage());
                response = Main.readCharacter();
                if (response == 49) {
                    CustomerQuoteRequest request = Main.getRequestFromUser();
                    UMOMessage result = loanConsumer.request(request);
                    if (result == null) {
                        System.out.println(new Message("loanbroker-example", 12).getMessage());
                        continue;
                    }
                    System.out.println(new Message("loanbroker-example", 13, result.getPayload()).getMessage());
                    continue;
                }
                if (response == 113) {
                    System.out.println(new Message("loanbroker-example", 14).getMessage());
                    loanConsumer.close();
                    System.exit(0);
                    continue;
                }
                System.out.println(new Message("loanbroker-example", 15).getMessage());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

