/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.routers;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.example.loanbroker.LocaleMessage;
import org.mule.example.loanbroker.messages.LoanQuote;
import org.mule.routing.EventGroup;

public class BankQuotesAggregationLogic {
    protected static final Log logger = LogFactory.getLog(BankQuotesAggregationLogic.class);

    public static MuleEvent aggregateEvents(EventGroup events) throws Exception {
        LoanQuote lowestQuote = null;
        LoanQuote quote = null;
        MuleEvent event = null;
        Iterator iterator = events.iterator(false);
        while (iterator.hasNext()) {
            event = (MuleEvent)iterator.next();
            Object o = event.getMessage().getPayload();
            if (!(o instanceof LoanQuote)) {
                throw new IllegalArgumentException("Object received by Aggregator is not of expected type. Wanted: " + LoanQuote.class.getName() + " Got: " + o);
            }
            quote = (LoanQuote)o;
            logger.info((Object)LocaleMessage.processingQuote(quote));
            if (lowestQuote == null) {
                lowestQuote = quote;
                continue;
            }
            if (!(quote.getInterestRate() < lowestQuote.getInterestRate())) continue;
            lowestQuote = quote;
        }
        logger.info((Object)LocaleMessage.lowestQuote(lowestQuote));
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage(lowestQuote, event.getMessage(), event.getMuleContext()), event);
    }
}

