/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.transformers;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.example.loanbroker.messages.Customer;
import org.mule.example.loanbroker.messages.CustomerQuoteRequest;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class RestRequestToCustomerRequest
extends AbstractMessageAwareTransformer {
    public RestRequestToCustomerRequest() {
        this.setReturnDataType(DataTypeFactory.create(CustomerQuoteRequest.class));
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        int duration;
        double amount;
        int ssn;
        String name;
        try {
            name = this.getParam(message, "customerName");
            ssn = Integer.parseInt(this.getParam(message, "ssn"));
            amount = Double.parseDouble(this.getParam(message, "loanAmount"));
            duration = Integer.parseInt(this.getParam(message, "loanDuration"));
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        Customer c = new Customer(name, ssn);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, amount, duration);
        return request;
    }

    protected String getParam(MuleMessage message, String name) throws NullPointerException {
        String value = message.getStringProperty(name, null);
        if (value == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' must be set on the request");
        }
        return value;
    }
}

