/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.transformers;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.examples.loanbroker.bank.Bank;
import org.mule.examples.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class SetLendersAsRecipients
extends AbstractMessageAwareTransformer {
    public SetLendersAsRecipients() {
        this.registerSourceType(LoanBrokerQuoteRequest.class);
        this.setReturnClass(MuleMessage.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        Bank[] lenders = ((LoanBrokerQuoteRequest)src).getLenders();
        String recipients = "";
        for (int i = 0; i < lenders.length; ++i) {
            if (i > 0) {
                recipients = recipients + ",";
            }
            recipients = recipients + lenders[i].getEndpoint();
        }
        this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
        message.setProperty("recipients", (Object)recipients);
        return message;
    }
}

