/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.transformers;

import org.mule.examples.loanbroker.bank.Bank;
import org.mule.examples.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class SetLendersAsRecipients
extends AbstractMessageAwareTransformer {
    public SetLendersAsRecipients() {
        this.registerSourceType(LoanBrokerQuoteRequest.class);
    }

    public Object transform(UMOMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        Bank[] lenders = ((LoanBrokerQuoteRequest)src).getLenders();
        String recipients = "";
        for (int i = 0; i < lenders.length; ++i) {
            if (i > 0) {
                recipients = recipients + ",";
            }
            recipients = recipients + lenders[i].getEndpoint();
        }
        this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
        message.setProperty("recipients", (Object)recipients);
        return message;
    }
}

