/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.examples.loanbroker.LoanBrokerException;
import org.mule.examples.loanbroker.LoanBrokerService;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.examples.loanbroker.messages.LoanBrokerQuoteRequest;
import org.mule.examples.loanbroker.messages.LoanQuote;

public class DefaultLoanBroker
implements LoanBrokerService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicInteger quotes = new AtomicInteger(0);
    private final AtomicInteger requests = new AtomicInteger(0);

    public LoanBrokerQuoteRequest getLoanQuote(CustomerQuoteRequest request) throws LoanBrokerException {
        int requests = this.incRequests();
        if (this.logger.isInfoEnabled()) {
            Object[] params = new String[]{String.valueOf(requests), request.getCustomer().getName(), String.valueOf(request.getCustomer().getSsn()), String.valueOf(request.getLoanAmount()), String.valueOf(request.getLoanDuration())};
            this.logger.info((Object)("\n***** " + new Message("loanbroker-example", 1, params).getMessage()));
        }
        LoanBrokerQuoteRequest bqr = new LoanBrokerQuoteRequest();
        bqr.setCustomerRequest(request);
        return bqr;
    }

    public LoanQuote receiveQuote(LoanQuote quote) {
        int quotes = this.incQuotes();
        if (this.logger.isInfoEnabled()) {
            Object[] params = new String[]{String.valueOf(quotes), quote.toString()};
            this.logger.info((Object)("\n***** " + new Message("loanbroker-example", 2, params).getMessage()));
        }
        return quote;
    }

    protected int incQuotes() {
        return this.quotes.incrementAndGet();
    }

    protected int incRequests() {
        return this.requests.incrementAndGet();
    }
}

