/*
 * Decompiled with CFR 0.152.
 */
package org.mule.example.loanbroker.tests;

import org.mule.api.MuleMessage;
import org.mule.example.loanbroker.messages.Customer;
import org.mule.example.loanbroker.messages.CustomerQuoteRequest;
import org.mule.example.loanbroker.messages.LoanQuote;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.NullPayload;

public abstract class AbstractLoanBrokerTestCase
extends FunctionalTestCase {
    protected int getNumberOfRequests() {
        return 10;
    }

    public void testSingleLoanRequest() throws Exception {
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, 100000.0, 48);
        MuleMessage result = client.send("CustomerRequests", (Object)request, null);
        AbstractLoanBrokerTestCase.assertNotNull((String)"Result is null", (Object)result);
        AbstractLoanBrokerTestCase.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
        AbstractLoanBrokerTestCase.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
        LoanQuote quote = (LoanQuote)result.getPayload();
        AbstractLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfLoanRequests() throws Exception {
        int i;
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest[] requests = new CustomerQuoteRequest[]{new CustomerQuoteRequest(c, 100000.0, 48), new CustomerQuoteRequest(c, 1000.0, 12), new CustomerQuoteRequest(c, 10.0, 24)};
        long start = System.currentTimeMillis();
        int numRequests = this.getNumberOfRequests();
        try {
            for (i = 0; i < numRequests; ++i) {
                CustomerQuoteRequest loanRequest = requests[i % 3];
                MuleMessage result = client.send("CustomerRequests", (Object)loanRequest, null);
                AbstractLoanBrokerTestCase.assertNotNull((Object)result);
                AbstractLoanBrokerTestCase.assertFalse((String)"received a NullPayload", (boolean)(result.getPayload() instanceof NullPayload));
                AbstractLoanBrokerTestCase.assertTrue((String)("did not receive a LoanQuote but: " + result.getPayload()), (boolean)(result.getPayload() instanceof LoanQuote));
                LoanQuote quote = (LoanQuote)result.getPayload();
                AbstractLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            long el = System.currentTimeMillis() - start;
            System.out.println("Total running time was: " + el + "ms");
            System.out.println("Requests processed was: " + i);
            int mps = (int)((double)numRequests / ((double)el / 1000.0));
            System.out.println("Msg/sec: " + mps + " (no warm up)");
            throw throwable;
        }
        long el = System.currentTimeMillis() - start;
        System.out.println("Total running time was: " + el + "ms");
        System.out.println("Requests processed was: " + i);
        int mps = (int)((double)numRequests / ((double)el / 1000.0));
        System.out.println("Msg/sec: " + mps + " (no warm up)");
    }
}

