/*
 * Decompiled with CFR 0.152.
 */
package org.mule.examples.loanbroker.tests;

import org.mule.examples.loanbroker.messages.Customer;
import org.mule.examples.loanbroker.messages.CustomerQuoteRequest;
import org.mule.examples.loanbroker.messages.LoanQuote;
import org.mule.examples.loanbroker.tests.AbstractLoanBrokerTestCase;
import org.mule.extras.client.MuleClient;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;

public abstract class AbstractAsynchronousLoanBrokerTestCase
extends AbstractLoanBrokerTestCase {
    protected int getNumberOfRequests() {
        return 100;
    }

    protected int getDelay() {
        return 5000;
    }

    public void testSingleLoanRequest() throws Exception {
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest request = new CustomerQuoteRequest(c, 100000.0, 48);
        client.dispatch("CustomerRequests", (Object)request, null);
        UMOMessage result = client.receive("CustomerResponses", (long)this.getDelay());
        AbstractAsynchronousLoanBrokerTestCase.assertNotNull((String)"Result is null", (Object)result);
        AbstractAsynchronousLoanBrokerTestCase.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
        LoanQuote quote = (LoanQuote)result.getPayload();
        AbstractAsynchronousLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfLoanRequests() throws Exception {
        MuleClient client = new MuleClient();
        Customer c = new Customer("Ross Mason", 1234);
        CustomerQuoteRequest[] requests = new CustomerQuoteRequest[]{new CustomerQuoteRequest(c, 100000.0, 48), new CustomerQuoteRequest(c, 1000.0, 12), new CustomerQuoteRequest(c, 10.0, 24)};
        long start = System.currentTimeMillis();
        int numRequests = this.getNumberOfRequests();
        int i = 0;
        try {
            for (i = 0; i < numRequests; ++i) {
                client.dispatch("CustomerRequests", (Object)requests[i % 3], null);
            }
            for (i = 0; i < numRequests; ++i) {
                UMOMessage result = client.receive("CustomerResponses", (long)(this.getDelay() * numRequests));
                AbstractAsynchronousLoanBrokerTestCase.assertNotNull((String)"Result is null", (Object)result);
                AbstractAsynchronousLoanBrokerTestCase.assertFalse((String)"Result is null", (boolean)(result.getPayload() instanceof NullPayload));
                AbstractAsynchronousLoanBrokerTestCase.assertTrue((String)("Result should be LoanQuote but is " + result.getPayload().getClass().getName()), (boolean)(result.getPayload() instanceof LoanQuote));
                LoanQuote quote = (LoanQuote)result.getPayload();
                AbstractAsynchronousLoanBrokerTestCase.assertTrue((quote.getInterestRate() > 0.0 ? 1 : 0) != 0);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            long el = System.currentTimeMillis() - start;
            System.out.println("Total running time was: " + el + "ms");
            System.out.println("Requests processed was: " + i);
            int mps = (int)((double)numRequests / ((double)el / 1000.0));
            System.out.println("Msg/sec: " + mps + " (no warm up)");
            throw throwable;
        }
        long el = System.currentTimeMillis() - start;
        System.out.println("Total running time was: " + el + "ms");
        System.out.println("Requests processed was: " + i);
        int mps = (int)((double)numRequests / ((double)el / 1000.0));
        System.out.println("Msg/sec: " + mps + " (no warm up)");
    }
}

